exports.Task = extend(TolokaHandlebarsTask, function (options) {
    TolokaHandlebarsTask.call(this, options);
}, {

    onRender: function() {
        var $this = $(this.getDOMElement());
        $this.on('click', '.radio', this._onRadioChanged.bind(this));
    },

    _onRadioChanged: function(e) {
        var $this = $(this.getDOMElement());
        var $input = $(e.target).find('input[name=result]');
        var value = $input.val();
        
        if (value == 'GOOD' || value == 'OK' || value == 'BAD') {
            $this.find('.reasons').slideDown();
        } else if (value == 'EXCELLENT' || value == '404') {
            $this.find('.reasons').slideUp();
        }
    },

    onKey: function(key) {
        var $this = $(this.getDOMElement());

        if (key == '2' || key == '3' || key == '4') {
            $this.find('.reasons').slideDown();
        } else if (key == '1' || key == '5') {
            $this.find('.reasons').slideUp();
        }

        if (key == '9') {
            $this.find('input[name=bad_something]').focus();
        }
        TolokaHandlebarsTask.prototype.onKey.apply(this, arguments);
    },

    addError: function(message, field, errors) {
        errors || (errors = {
            task_id: this.getOptions().task.id,
            errors: {}
        });
        errors.errors[field] = {
            message: message
        };

        return errors;
    },

    validate: function(solution) {
        var errors = TolokaHandlebarsTask.prototype.validate.apply(this, arguments);

        console.log('validate', errors, this);
        var output = this.getSolution().output_values;
        var result = output.result;

        if (result == 'GOOD' || result == 'OK' || result == 'BAD') {
            if (!output.is_bad_content && !output.is_bad_quality && !output.is_bad_size && !output.is_bad_something) {
                errors = this.addError('Выберите как минимум 1 аспект', '__TASK__', errors);
            }
            if (output.is_bad_something && (!output.bad_something || output.bad_something.length < 4)) {
                errors = this.addError('Напишите, пожалуйста, почему картинка не отличная', '__TASK__', errors);
            }
        }

        return errors;
    }

});


function extend(ParentClass, constructorFunction, prototypeHash) {
    constructorFunction = constructorFunction || function () {};
    prototypeHash = prototypeHash || {};
    if (ParentClass) {
        constructorFunction.prototype = Object.create(ParentClass.prototype);
    }
    for (var i in prototypeHash) {
        constructorFunction.prototype[i] = prototypeHash[i];
    }
    return constructorFunction;
}



$('body').on('click', 'img.image', function(e) {
    $(this).parent().toggleClass('zoomed');
});
