#!/usr/bin/env python
# coding: utf-8

import sys
import json
import requests
import wiki_api
import argparse
from datetime import datetime
from time import sleep


def download_json(url):
    r = requests.get(url, verify=False)
    r.encoding = 'utf-8'
    return r.json()


def read_json(file_name):
    with open(file_name) as data_file:
        data = json.load(data_file)

    return data


def parse_experiments(experiments):
    rows = []

    for exp in experiments:
        try:
            date_start = datetime.strptime(exp['date_start'], '%Y%m%d').strftime('%Y-%m-%d')
            date_end = datetime.strptime(exp['date_end'], '%Y%m%d').strftime('%Y-%m-%d')
        except:
            date_start = ''
            date_end = ''
        row = {
            'added_row': {
                'after_id': '-1',
                'data': {
                    '100': exp['type'],
                    '101': exp['desc'],
                    '102': exp['task'],
                    '103': date_start,
                    '104': date_end
                }
            }
        }
        if 'apriori' in exp and len(exp['apriori']) > 0:
            row['added_row']['data']['105'] = True
        rows.append(row)

    return rows


def main(params):
    print 'Parse json... '
    if params['url']:
        source_json = download_json(params['url'])
    else:
        source_json = read_json(params['input'])

    new_experiments = parse_experiments(source_json['observations'])
    print 'Done. Parsed ', len(new_experiments), ' exps'

    print 'Clear grid... '
    wiki_api.clear_grid(params['wiki_page'])
    print 'Done'

    print 'Upload exps.. ',
    #print wiki_api.change_grid(params['wiki_page'], new_experiments)

    chunk = []
    for exp in new_experiments:
        chunk.append(exp)
        if len(chunk) == 10:
	    print wiki_api.change_grid(params['wiki_page'], chunk)
            chunk = []
            sleep(0.5)
    print 'Done'


if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Upload experiments from json file to wiki table')
    parser.add_argument('-i', metavar='input', dest='input', help='Path to local file with json with experiments')
    parser.add_argument('-u', metavar='url', dest='url', help='Url to file with json with experiments')
    parser.add_argument('-o', metavar='wiki_page', dest='wiki_page', help='Wiki path with experiments table')
    args = vars(parser.parse_args())

    if not args['wiki_page'] or (not args['input'] and not args['url']):
        print parser.print_help()
        sys.exit(2)

    main(args)
