#!/bin/bash

if [ "$#" -ne 3 ]; then
    echo "USAGE: $0 <config_id> <date_from> <date_to_included>" >&2
    exit 1
fi

while true; do
    echo -e "Run YQL mining for config ${1}, [${2}..${3}]?"
    read yn
    case $yn in
        [Yy]* ) break;;
        [Nn]* ) exit;;
        * ) echo "Please answer yes or no.";;
    esac
done

curl -XPOST 'https://yqlminer.metrics.yandex-team.ru/api/mining/runMining' -v -H "Authorization: OAuth $( cat ~/.metrics/token )" -H 'Content-Type: application/json;charset=UTF-8' -d'{
  "configurationId": "'${1}'",
  "minDate": "'${2}'",
  "maxDate": "'${3}'",
  "parameterValues": {}
}' | jq -r '.'
