#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import datetime
import argparse
import json
import sys
import csv

def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("-f", "--file", dest="file", required=True,
                        help="Input file with data")
    return parser

def main():
    args = HandleOption().parse_args()
    shows_total={}
    clicks_total={}
    wiz_shows=0
    filter={'network':0,'age':0,'total':0,'geo':0,'edu':0,'job':0}
    with open(args.file, "r") as f:
        fields = ['reqid' , 'empty' , 'value']
        data = csv.DictReader(f, fieldnames=fields, delimiter='\t')
        for row in data:
            val = json.loads(row['value'])
            for f in filter:
                filter[f]+=val['filter'][f]
            wiz_shows+=val['wizard']
            for p in val['serp']:
                if p in shows_total:
                    shows_total[p]+=1
                else:
                    shows_total[p]=1
                if val['serp'][p] in val['clicks']:
                    if p in clicks_total:
                        clicks_total[p]+=1
                    else:
                        clicks_total[p]=1
    print filter
    for pos in shows_total:
        if pos in clicks_total:
            print int(pos),'\t',clicks_total[pos]/shows_total[pos]
        else:
            print int(pos),'\t',0
if __name__ == "__main__":
    main()
