#!/usr/bin/env python
# -*- coding: utf-8 -*-

from mapreducelib import MapReduce, Record
import sys
import libra
import urllib, cgi
import random

fage=259200

def countsurplus(key, recs):
    uid = key

    try:
        session = libra.ParseSession(recs, './blockstat.dict') # it takes whole raw session and blockstat.dict and returns a list on TRequest objects
    except:
        return

    for request in session:
        win = 0
        loss = 0
        if request.IsA("TYandexWebRequest"):
            type="web"
        elif request.IsA("TMobileYandexWebRequest"):
            type="mobile"
        elif request.IsA("TTouchYandexWebRequest"):
            type="touch"
        else:
            continue

        region = request.ServiceDomRegion
        if region != 'ru':
            continue
        query = request.Query
        if 'серия' in query.lower():
            tv=True
        else:
            continue
        hasfresh= False
        for block in request.GetMainBlocks():
            c=0
            for click in block.GetClicks():
                if click.DwellTime >= 15:
                    c+=1
            res = block.GetMainResult()
            if res.IsA("TWebResult"):
                m=res.Markers
                if ("FreshAge" in m) and (int(m['FreshAge'])<=fage):
                    win+=c
                    hasfresh=True
                    continue
            if hasfresh:
                loss+=c
                hasfresh= False
        yield Record('win','',str(win))
        yield Record('loss','',str(loss))

def main():
    blockstat = '/home/itajn/serploader/blockstat.dict'
    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'freshness',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )
    dates=['20160109','20160110','20160111','20160112','20160113','20160114','20160115','20160116','20160117','20160118','20160119','20160120','20160121','20160122','20160123','20160124','20160125','20160126']
    #'1460471400'
    for day in dates:
        usersessions='user_sessions/'+day
        output = 'itajn/FR-1989/'+day
        MapReduce.runReduce(countsurplus,
                         srcTable = usersessions,
                         dstTables = [output],
                         files = [blockstat],
                         sortMode = True
                        )

if __name__ == '__main__':
    main()
