#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import division
from mapreducelib import MapReduce, Record, TemporaryTable
import sys
import re
import argparse


def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("--server", dest="server", help="mapreduce server",default='sakura.search.yandex.net:8013', required=False)
    parser.add_argument("--user", dest="user", help="mapreduce user",default='freshness', required=False)
    parser.add_argument("--mr", dest="mr", help="mapreduce binary",default='/Berkanavt/bin/mapreduce-dev', required=False)
    parser.add_argument("--bs", dest="blockstat", help="path to blockstat.dict",default='/home/itajn/serploader/blockstat.dict', required=False)
    return parser

def main():
    args = HandleOption().parse_args()
    MapReduce.useDefaults(
                            server   = args.server,
                            username = args.user,
                            mrExec   = args.mr,
                            verbose  = True,
                         )
    positions_win={'desk':{},'touch':{}}
    positions_loss={'desk':{},'touch':{}}
    poscount={'desk':{},'touch':{}}
    words_win={'desk':{},'touch':{}}
    words_loss={'desk':{},'touch':{}}
    wordscount={'desk':{},'touch':{}}
    days=["20160516","20160517","20160518","20160519","20160520","20160521","20160522","20160523","20160524","20160525","20160526","20160527","20160528","20160529","20160530"]
    for d in days:
        out='itajn/FR-1999/'+d
        result=MapReduce.getSample(out, count=None)
        for r in result:
            if r.subkey=='Desktop':
                type='desk'
            else:
                type='touch'
            query=r.key
            tmp=r.value.split('\t')
            pos=int(tmp[0])+1
            wordcnt=int(tmp[1])
            if pos > 11 or wordcnt >11:
                continue
            win=int(tmp[2])
            loss=int(tmp[3])
            #4 - isnav, 5 - tv, 6 - news rub, 7 - newswiz
            isnav=tmp[4]
            #if isnav=='False':
            #    continue
            if not (('хоке' in query.lower()) or ('хокке' in query.lower()) or ('футбо' in query.lower())):
                continue
            if pos in positions_win[type]:
                positions_win[type][pos]+=win
                positions_loss[type][pos]+=loss
                poscount[type][pos]+=1
            else:
                positions_win[type][pos]=win
                positions_loss[type][pos]=loss
                poscount[type][pos]=1
            if wordcnt in words_win[type]:
                words_win[type][wordcnt]+=win
                words_loss[type][wordcnt]+=loss
                wordscount[type][wordcnt]+=1
            else:
                words_win[type][wordcnt]=win
                words_loss[type][wordcnt]=loss
                wordscount[type][wordcnt]=1
    for i in range(12):
        for t in ['desk','touch']:
            if not i in positions_win[t]:
                positions_win[t][i]=0
                positions_loss[t][i]=0
                poscount[t][i]=0
            if not i in words_win[t]:
                words_win[t][i]=0
                words_loss[t][i]=0
                wordscount[t][i]=0
        print i, positions_win['desk'][i], positions_loss['desk'][i], poscount['desk'][i], positions_win['touch'][i], positions_loss['touch'][i], poscount['touch'][i], words_win['desk'][i], words_loss['desk'][i], wordscount['desk'][i], words_win['touch'][i], words_loss['touch'][i], wordscount['touch'][i]

if __name__ == '__main__':
    main()
