#!/usr/bin/env python
# -*- coding: utf-8 -*-

import argparse
import json
import sys
from array import *
import numpy
import csv
import random

def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("-f", "--file", dest="file", required=True,
                        help="Input file with data")
    return parser

def main():
    args = HandleOption().parse_args()
    cposlices = [0,100,300,500]
    ipslices=[0.0,0.12,0.2,0.3,0.5]
    unique={}
    crit={}
    for s in cposlices:
        for i in ipslises:
            total[str(s)+'_'+c]=0


    with open(args.file, "r") as f:
        fields = ['query' , 'count' , 'decay', 'cpo', 'ip']
        data = csv.DictReader(f, fieldnames=fields, delimiter='\t')
        for row in data:
            count=int(row['count'])
            decay = float(row['decay'])
            ip = float(row['ip'])/(1+float(row['ip']))
            cpo=int(row['cpo'])
            for s in slices:
                #print >> sys.stderr, count, decay, cpo
                if count==1 and decay<=0.06 and cpo<=s:
                    inter[str(s)+'_slim']+=1
                    inter[str(s)+'_fat']+=1
                #else:
                    #if count==1:
                        #rnd=random.randint(0,100)
                        #if rnd == 67:
                            #print '\t'.join([row['query'], str(count), str(decay), str(cpo)])
                if count==1 or ( decay<=0.06 and cpo<=s ):
                    union[str(s)+'_slim']+=1
                    union[str(s)+'_fat']+=int(row['count'])
        print 'total_slim ', total_slim
        print 'total_fat', total_fat
 #       print 'undefined ', undefined
        print 'intersection ', inter
        print 'union ', union

if __name__ == "__main__":
    main()

