#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import argparse
import json
import sys
from array import *
import numpy
import csv
import random


def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("-f", "--file", dest="file", required=True,
                        help="Input file with data")
    return parser

def main():
    args = HandleOption().parse_args()
    cposlices = [100,300,500]
    ipslices=[0.0,0.12,0.2,0.3,0.5]
    unique={}
    crit={}
    crit_and={}
    both={}
    both_and={}
    uniq_cpo={}
    all_fresh={}
    for i in ipslices:
        unique[str(i)]=0
        all_fresh[str(i)]=0
        for c in cposlices:
            uniq_cpo[str(c)]=0
            crit[str(i)+'_'+str(c)]=0
            both[str(i)+'_'+str(c)]=0
            crit_and[str(i)+'_'+str(c)]=0
            both_and[str(i)+'_'+str(c)]=0

    with open(args.file, "r") as f:
        fields = ['query' , 'count' , 'decay', 'cpo', 'ip']
        data = csv.DictReader(f, fieldnames=fields, delimiter='\t')
        for row in data:
            count=int(row['count'])
            decay = float(row['decay'])
            ip = float(row['ip'])/(1+float(row['ip']))
            cpo=int(row['cpo'])
            for i in ipslices:
                if ip >= i:
                    all_fresh[str(i)]+=count
                if count == 1 and ip >= i:
                    unique[str(i)]+=count
                for c in cposlices:
                    if count == 1 and cpo > c:
                        uniq_cpo[str(c)]+=count
                    if (cpo <= c or decay <= 0.06) and ip>=i:
                        crit[str(i)+'_'+str(c)]+=count
                        if count == 1:
                            both[str(i)+'_'+str(c)]+=count
                    if cpo <= c and decay <= 0.06 and ip>=i:
                        crit_and[str(i)+'_'+str(c)]+=count
                        if count == 1:
                            both_and[str(i)+'_'+str(c)]+=count
                        #else:
                        #    rnd=random.randint(0,1000)
                        #    if rnd == 241:
                        #        print '\t'.join([row['query'],str(i), str(c), str(count), str(decay), str(cpo)])
        print uniq_cpo
        for i in ipslices:
            for c in cposlices:
                percent = crit_and[str(i)+'_'+str(c)] / all_fresh[str(i)]
                print i, c, percent
        #        precision = both[str(i)+'_'+str(c)]/crit[str(i)+'_'+str(c)]
        #        recall = both[str(i)+'_'+str(c)]/unique[str(i)]
        #        precision_and = both_and[str(i)+'_'+str(c)]/crit_and[str(i)+'_'+str(c)]
        #        recall_and = both_and[str(i)+'_'+str(c)]/unique[str(i)]
        #        print i, c, precision, recall, precision_and, recall_and
if __name__ == "__main__":
    main()
