#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import division
import sys
import re
import argparse
import csv


profile={'vk':ur'http(|s):\/\/(www\.|)vk.com\/[^w^t^v^p][^a^o^i^h][^l^p^d^o][^l^i^e^t]','google+':ur'http(|s):\/\/(www\.|)plus\.google\.com\/(u\/0\/[0-9]+|[^/]+)\/(posts|about)(\/|)$', 'smotra':ur'http(|s):\/\/(www\.|)smotra\.ru\/[^$]'}
post={'vk':ur'http(|s):\/\/(www\.|)vk.com\/(wall|topic|video|photo)','fb':ur'http(|s):\/\/(www\.|ru-ru\.|)facebook\.com\/[^/]+(\/|\.php)[^$]','twitter':ur'http(|s):\/\/(www\.|)twitter\.com/[^/]+\/[^$]', 'google+':ur'http(|s):\/\/(www\.|)plus\.google\.com\/(u\/0\/[0-9]+|[^/]+)\/posts\/[^$]'}


def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("--file", dest="file", help="input")
    return parser

def main():
    args = HandleOption().parse_args()
    with open(args.file, "r") as f:
        fields = ['site' , 'type' , 'clicks', 'pos']
        print 'profiles'
        for site in profile:
            total_shows=0
            total_clicks=0
            shows={}
            clicks={}
            f.seek(0)
            data = csv.DictReader(f, fieldnames=fields, delimiter='\t')
            for line in data:
                if site==line['site'] and line['type']=='profile':
                    pos=int(line['pos'])
                    total_shows+=1
                    cl=int(line['clicks'])
                    total_clicks+=cl
                    if pos >=11:
                        continue
                    if pos in shows:
                        shows[pos]+=1
                    else:
                        shows[pos]=1
                    if pos in clicks:
                        clicks[pos]+=cl
                    else:
                        clicks[pos]=cl
            print 'site:', site
            print total_shows, '\t', total_clicks
            for s in shows:
                if s in clicks:
                    print s, clicks[s]/shows[s]
                else:
                    print s, 0
if __name__ == '__main__':
    main()
