#!/usr/bin/env python
# -*- coding: utf-8 -*-

from mapreducelib import MapReduce, Record, TemporaryTable
import sys
import json
import argparse

def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("--server", dest="server", help="mapreduce server",default='sakura.search.yandex.net:8013', required=False)
    parser.add_argument("--user", dest="user", help="mapreduce user",default='freshness', required=False)
    parser.add_argument("--mr", dest="mr", help="mapreduce binary",default='/Berkanavt/bin/mapreduce-dev', required=False)
    parser.add_argument("--bs", dest="blockstat", help="path to blockstat.dict",default='/home/itajn/serploader/blockstat.dict', required=False)
    return parser


def main():
    args = HandleOption().parse_args()
    MapReduce.useDefaults(
                            server   = args.server,
                            username = args.user,
                            mrExec   = args.mr,
                            verbose  = True,
                         )
    days=['20160524','20160523','20160525','20160520','20160519','20160518','20160517']
    for day in days:
        marks={'tv':{'rel-':0,'irr':0,'rel+':0,'total':0}, 'nontv':{'rel-':0,'irr':0,'rel+':0,'total':0}}
        print day
        mr_path='freshness/pool/metrics/ru/'+day
        result=MapReduce.getSample(mr_path, count=None)
        for row in result:
            unit=json.loads(row.value)
            query=unit['query']
            if u'серия' in query.lower():
                type='tv'
            else:
                type='nontv'
            for url in unit['serps']['QUICK']:
                if "marks" in url:
                    for m in url['marks']:
                        marks[type]['total']+=1
                        if m['score']=='FRESH_REL_MINUS_85':
                            marks[type]['rel-']+=1
                        elif m['score']=='FRESH_REL_PLUS_85':
                            marks[type]['rel+']+=1
                        elif m['score']=='FRESH_IRREL_85':
                            marks[type]['irr']+=1
        print marks

if __name__ == '__main__':
    main()
