#!/usr/bin/env python
# -*- coding: utf-8 -*-

import yt.wrapper as yt
import sys
import argparse

def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("--server", dest="server", help="mapreduce server",default='banach.yt.yandex.net:80', required=False)
    return parser

def grepurls(rec):
    with open('./marked.txt', "r") as f:
        for row in f.readlines():
            line=row.strip()
            if line in rec["key"]:
                yield {'original': line,
                       'found': rec["key"],
                       'value': rec["value"],
                   }
                return

def main():
    args = HandleOption().parse_args()
    yt.update_config({'proxy': {'url': args.server}})
    input='//home/robot/mobile/walrus/exports/url_factors'
    output = '//home/peoplesearch/staff/FR-2153/marked'
    if not yt.exists(output):
        yt.create_table(path=output, recursive=True)
    yt.run_map(grepurls,
               source_table=input,
               destination_table=output,
               local_files = ['/home/itajn/FR-2153/marked.txt'])

if __name__ == '__main__':
    main()
