#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import argparse
import json
import heapq

def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("--type", dest="type", help="name for vertical", required=True)
    parser.add_argument("--num", dest="num", help="number of queries", default='10000', required=False)
    parser.add_argument("--top", dest="outtop", help="file for best queries", required=True)
    parser.add_argument("--low", dest="outlow", help="file for worst queries", required=True)
    parser.add_argument("--input", dest="input", help="file with queries to filter", required=True)
    return parser

def main():
    args = HandleOption().parse_args()
    num=int(args.num)
    top=[]
    bottom=[]
    with open(args.input,"r") as input:
        for line in input:
            result=json.loads(line)
            if result["type"]==args.type:
                if len(top)==num:
                    lmn=heapq.heappop(top)
                    new=(int(result['surplus']),result['query'])
                    if lmn>new:
                        heapq.heappush(top,lmn)
                    else:
                        heapq.heappush(top,new)
                else:
                    heapq.heappush(top,(int(result['surplus']),result['query']))
                if len(bottom)==num:
                    lmn=heapq.heappop(bottom)
                    new=(-1*int(result['surplus']),result['query'])
                    if lmn>new:
                        heapq.heappush(bottom,lmn)
                    else:
                        heapq.heappush(bottom,new)
                else:
                    heapq.heappush(bottom,(-1*int(result['surplus']),result['query']))
        with open(args.outtop, "w") as filetop:
            for q in sorted(top, reverse=True):
                filetop.write(q[1].encode('utf-8',errors='ignore')+'\t'+str(q[0])+'\n')
        with open(args.outlow, "w") as filelow:
            for q in sorted(bottom, reverse=True):
                filelow.write(q[1].encode('utf-8',errors='ignore')+'\t'+str(-1*q[0])+'\n')

if __name__ == '__main__':
    main()
