#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import argparse

def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("--fields", dest="fields", help="name for fields", required=True)
    parser.add_argument("--input", dest="input", help="csv file to format", required=True)
    parser.add_argument("--separator", dest="sep", default="=", required=False)
    return parser

def main():
    args = HandleOption().parse_args()
    fields = args.fields.split(',')
    with open(args.input,"r") as input:
        for line in input:
            out = ''
            l = line.split('\t')
            for f in range(len(fields)):
                out += fields[f] + args.sep + l[f] + '\t'
            print out.strip()

if __name__ == '__main__':
    main()
