#!/usr/bin/env python
# -*- coding: utf-8 -*-

import yt.wrapper as yt
import sys
import libra
import argparse


def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("--server", dest="server", help="mapreduce server",default='hahn.yt.yandex.net', required=False)
    parser.add_argument("--bs", dest="blockstat", help="path to blockstat.dict",default='/home/itajn/serploader/blockstat.dict', required=False)
    return parser

def countsurplus(key,recs):
    uid = key
    #try:
    session = libra.ParseSession(recs, './blockstat.dict')
    #except:
    #    return
    for request in session:
        i=0
        if not (request.IsA("TYandexWebRequest") or request.IsA("TMobileYandexWebRequest") or request.IsA("TTouchYandexWebRequest")):
            continue
        for block in request.GetMainBlocks():
            res=block.GetMainResult()
            if res.IsA("TBlenderWizardResult")or res.IsA("TWizardResult"):
                print >> sys.stderr, res.Name
            elif res.IsA("TWebResult"):
                if res.Source.lower()=='biathlon':
                    print >> sys.stderr, res.Source

def main():
    args = HandleOption().parse_args()
    yt.update_config({'proxy': {'url': args.server}})
    dates=['2016-08-15']
    for day in dates:
        usersessions='//user_sessions/pub/search/daily/'+day+'/clean'
        output = '//home/freshness/staff/itajn/FR-2337/'+day
        yt.run_reduce(countsurplus,
                      source_table=usersessions,
                      destination_table=output,
                      local_files = [args.blockstat],
                      reduce_by = 'key')

if __name__ == '__main__':
    main()
