#!/usr/bin/env python
# -*- coding: utf-8 -*-

import yt.wrapper as yt
import sys
import heapq
import argparse


def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("--server", dest = "server", help = "yt server",default = 'hahn.yt.yandex.net', required = False)
    parser.add_argument("--bs", dest = "blockstat", help = "path to blockstat.dict",default = '/home/itajn/serploader/blockstat.dict', required = False)
    return parser

def main():
    args = HandleOption().parse_args()
    yt.update_config({'proxy': {'url': args.server}})
    wizards=['fresh','news','video','images','maps','adresa']
    key = 'ip_avg'
    reverse = 1
    census = 1
    heapsize = 500000
    dates=['2016-07-11', '2016-07-12', '2016-07-13', '2016-07-14', '2016-07-15', '2016-07-16', '2016-07-17', '2016-07-18', '2016-07-19', '2016-07-20', '2016-07-21', '2016-07-22', '2016-07-23', '2016-07-24']
    for day in dates:
        input = '//home/freshness/staff/itajn/FR-2363/' + day +'_agg'
        top = []
        result = yt.read_table(input)
        for r in result:
            r['query'] = r['query'].decode("utf-8",errors='ignore')
            if r['count'] >= census:
                if len(top) == heapsize:
                    lmn = heapq.heappop(top)
                    new = (reverse * r[key], r)
                    if lmn > new:
                        heapq.heappush(top, lmn)
                    else:
                        heapq.heappush(top, new)
                else:
                    heapq.heappush(top, (reverse * r[key], r))
        surplus = {}
        count = {}
        for w in wizards:
            surplus[w] = 0
            count[w] = 0
        for h in range(len(top)):
            for w in wizards:
                suplus[w] += top[h][1][w]
                count[w] += top[h][1][w+'_shows']
        out = day
        for w in wizards:
            out += '\t' + str(surplus[w]) + '\t' + str(count[w])
        print out

if __name__ ==  '__main__':
    main()
