#!/usr/bin/env python
# -*- coding: utf-8 -*-

import yt.wrapper as yt
import sys
import libra
import argparse

testid = '31174'

def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("--server", dest="server", help="yt server",default='hahn.yt.yandex.net', required=False)
    parser.add_argument("--bs", dest="blockstat", help="path to blockstat.dict",default='/home/itajn/serploader/blockstat.dict', required=False)
    return parser

def findbrowser(key, recs):
    uid = key
    try:
        session = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    for request in session:
        if not request.IsA("TYandexWebRequest"):
            continue
        if not request.HasTestID(testid):
            continue
        if not ('qvoice=1' in request.FullRequest or 'query_source=voice' in request.FullRequest):
            continue
        browser = request.GetBrowser()
        yield {'browser' : browser[0], 'version' : browser[1]}


def main():
    args = HandleOption().parse_args()
    yt.update_config({'proxy': {'url': args.server}})
    browsers = {}
    days = ['2016-09-07', '2016-09-08', '2016-09-09', '2016-09-10', '2016-09-11', '2016-09-12', '2016-09-13', '2016-09-14', '2016-09-15', '2016-09-16', '2016-09-17', '2016-09-18', '2016-09-19']
    for day in days:
        usersessions= '//user_sessions/pub/search/daily/' + day + '/clean'
        output = '//home/freshness/staff/itajn/FR-2386/' + day
        if not yt.exists(output):
            yt.create_table(path=output, recursive=True)
        yt.run_reduce(findbrowser,
                      source_table = usersessions,
                      destination_table = output,
                      local_files = [args.blockstat],
                      reduce_by = 'key',
                      spec = {'data_size_per_job': 16000000000} #~16GB
                      )

        result = yt.read_table(output)
        for r in result:
            b = (r['browser'], r['version'])
            if b in browsers:
                browsers[b] += 1
            else:
                browsers[b] = 1
    print b


if __name__ == '__main__':
    main()
