#!/usr/bin/env python
# -*- coding: utf-8 -*-

import yt.wrapper as yt
import sys
import libra
import argparse

testid = '32789'

def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("--server", dest="server", help="yt server",default='hahn.yt.yandex.net', required=False)
    parser.add_argument("--bs", dest="blockstat", help="path to blockstat.dict",default='/home/itajn/serploader/blockstat.dict', required=False)
    return parser

def countsurplus(key, recs):
    uid = key
    try:
        session = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    for request in session:
        win = 0
        loss = 0
        hasit = False
        was = False
        if not (request.IsA("TMobileYandexWebRequest") or request.IsA("TTouchYandexWebRequest")):
            continue
        if not request.HasTestID(testid):
            continue
        if request.IsA('TMiscRequestProperties'):
            sprops=request.SearchPropsValues
        if not ('QUICK.NewsFromQuickMiddle.HasAMP' in sprops and int(sprops['QUICK.NewsFromQuickMiddle.HasAMP']) == 1):
            continue
        query = request.Query.lower()
        if len(query) > 4095:
            query=query[:4095]
        for block in request.GetMainBlocks():
            c=0
            for click in block.GetClicks():
                if int(click.DwellTime) >= 15:
                    c+=1
            res = block.GetMainResult()
            if res.IsA("TBlenderWizardResult")or res.IsA("TWizardResult"):
                if res.Name=="news":
                    win += c
                    hasit = True
                    continue
            if hasit:
                loss += c
                break
        yield {'query' : query, 'win' : win, 'loss' : loss}


def main():
    args = HandleOption().parse_args()
    yt.update_config({'proxy': {'url': args.server}})

    days = ['2016-10-06', '2016-10-07', '2016-10-08', '2016-10-09', '2016-10-10']
    for day in days:
        usersessions= '//user_sessions/pub/search/daily/' + day + '/clean'
        output = '//home/freshness/staff/itajn/FR-2411/' + day
        if not yt.exists(output):
            yt.create_table(path=output, recursive=True)
        yt.run_reduce(countsurplus,
                      source_table = usersessions,
                      destination_table = output,
                      local_files = [args.blockstat],
                      reduce_by = 'key',
                      spec = {'data_size_per_job': 16000000000} #~16GB
                      )
        allwin = 0
        allloss = 0
        count = 0
        result = yt.read_table(output)
        for r in result:
            count += 1
            allwin += r['win']
            allloss += r['loss']
        print day, count, allwin, allloss

if __name__ == '__main__':
    main()
