#!/usr/bin/env python
# -*- coding: utf-8 -*-

try:
    import job_context as nv
except:
    import nirvana.job_context as nv

import datetime
import json
import sys
import time
import urllib
import urllib2
import requests

import nirvana_api as nrv_api


def main():
    job_context = nv.context()
    outputs = job_context.get_outputs()
    params = job_context.get_parameters()

    oauth = params.get("sbs-token")

    parent_ticket = params.get("ticket-id")
    date = datetime.datetime.fromtimestamp(int(params.get("timestamp")[:10]))
    servertime = datetime.datetime.now()
    title = params.get("title") + " " + date.strftime("%Y-%m-%d %H:%M")
    description = "This SbS was created automatically from Hitman. Parent SBS ticket #" + parent_ticket + ". Actual time of creation: " + servertime.strftime("%Y-%m-%d %H:%M")

    #clone ticket
    try:
        print >> sys.stderr, "Cloning ticket #", parent_ticket
        r = requests.post("https://sbs.yandex-team.ru/api/experiment/" + parent_ticket + "/clone",
                                  headers = { "Content-Type": "application/json",
                                              "Authorization" : "OAuth " + oauth},
                                  data = json.dumps({"regular": True, "autoStart": True, "description" : description, "title" : title}),
                                  verify = False
                         )
        print >> sys.stderr, r, r.content
    except requests.exceptions.HTTPError as e:
        raise Exception("HTTP Error " + e.code)
    answer = json.loads(r.content)
    if "error" in answer.keys():
        raise Exception("Samadhi error on cloning ticket: %s" % str(answer["error"]))
    new_ticket = str(answer["id"])

    #create graph
    try:
        print >> sys.stderr, "Making graph for ticket #", new_ticket
        r = requests.post("https://sbs.yandex-team.ru/api/experiment/" + new_ticket + "/workflow",
                                  headers = { "Authorization" : "OAuth " + oauth},
                                  verify = False
                          )
        print >> sys.stderr, r, r.content
    except requests.exceptions.HTTPError as e:
        raise Exception("HTTP Error " + e.code)
    answer = json.loads(r.content)
    if "error" in answer.keys():
        raise Exception("Samadhi error on creating graph: %s" % str(answer["error"]))
    graph_id = str(answer["id"])

    #run graph
    try:
        print >> sys.stderr, "Running graph #", graph_id
        r = requests.post("https://sbs.yandex-team.ru/api/workflow/" + graph_id + "/start",
                                  headers = { "Authorization" : "OAuth " + oauth},
                                  verify = False
                          )
        print >> sys.stderr, r, r.content
    except requests.exceptions.HTTPError as e:
        raise Exception("HTTP Error " + e.code)
    answer = json.loads(r.content)
    if "error" in answer.keys():
        raise Exception("Samadhi error on running graph: %s" % str(answer["error"]))

    result =  {"sbs-ticket": "SIDEBYSIDE-"+ new_ticket, "sbs-workflow-uids": [ graph_id ] }
    with open(outputs.get("result"), "w") as output:
        json.dump(result, output)
    output.close()


if __name__ == "__main__":
    main()
