#!/usr/bin/env python
# -*- coding: utf-8 -*-

try:
    import job_context as nv
except:
    import nirvana.job_context as nv

import datetime
import json
import sys
import time
import urllib
import urllib2

import nirvana_api as nrv_api


def main():
    job_context = nv.context()
    outputs = job_context.get_outputs()
    inputs = job_context.get_inputs()
    params = job_context.get_parameters()

    with open(inputs.get('graph_id'), 'r') as input:
        data = json.load(input)
    graph = data["sbs-workflow-uids"][0]
    ticket = data["sbs-ticket"]

    oauth = params.get("nirvana-token")
    newApi = nrv_api.NirvanaAPI(graph, oauth)
    url = 'https://nirvana.yandex-team.ru/flow/%s' % newApi.wfId

    while True:
        try:
            state = newApi.GetExecutionState()
        except Exception as e:
            print >> sys.stderr, 'Could not get execution state because: %s' % e
            time.sleep(60)
            continue
        if state == 'FAIL_JSON':
            print >> sys.stderr, 'State FAIL_JSON for flow %s' % url
        elif state['result']['status'] not in ['undefined', 'running']:
            break
        time.sleep(60)
    while True:
        try:
            result = newApi.GetExecutionState()
            break
        except Exception as e:
            print >> sys.stderr, 'Could not get execution state because: %s' % e
            time.sleep(60)
            continue
    if result['result']['status'] != 'completed' or result['result']['result'] != 'success':
        print >> sys.stderr, 'Workflow %s was not successfull' % url
        with open(outputs.get('result'), 'w') as output:
            json.dump({"state" : "failed"}, output)
            output.close()
    else:
        result =  {"state" : "ok", "sbs-ticket": ticket, "st-ticket": ticket, "sbs-workflow-uids": [ graph ], "workflow-id": graph}
        with open(outputs.get('result'), 'w') as output:
            json.dump(result, output)
        output.close()


if __name__ == '__main__':
    main()
