#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import division
import yt.wrapper as yt
import sys
import argparse
import json
import datetime
import math


def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("--server", dest = "server", help = "yt server", default = 'hahn.yt.yandex.net', required = False)
    parser.add_argument("--file", dest = "input", help = "input file with sbs pairs", required = True)
    parser.add_argument("--out", dest = "output", help = "output file with metrics", required = True)
    parser.add_argument("--ts", dest = "timestamp", help = "timestamp", required = True)
    parser.add_argument("--prod", dest = "prod", help = "number of production", default = '0', required = False)
    parser.add_argument("--old", dest = "old", help = "number of old_system", default = '2', required = False)
    parser.add_argument("--path", dest = "path", help = "YT path to history", default = '//home/freshness/staff/itajn/FR-2546/history', required = False)
    parser.add_argument("--name", dest = "name", help = "Name of the comparison", default = "production_vs_april", required = False)
    return parser


def significance(prod, old, p):
    k ={95 : 1.96, 99 : 2.576}
    total = prod + old
    share_prod = prod / total
    prod_left = share_prod - k[p] * math.sqrt((share_prod) * (1 - (share_prod)) / total)
    prod_right = share_prod + k[p] * math.sqrt((share_prod) * (1 - (share_prod)) / total)
    share_old = old / total
    old_left = share_old - k[p] * math.sqrt((share_old) * (1 - (share_old)) / total)
    old_right = share_old + k[p] * math.sqrt((share_old) * (1 - (share_old))/ total)
    if (old_left - prod_right) * (old_right - prod_left) > 0.0:
        return True
    else:
        return False

def main():
    args = HandleOption().parse_args()
    yt.update_config({'proxy': {'url': args.server}})

    ts = int(args.timestamp[:10])
    date = datetime.datetime.fromtimestamp(ts).date()
    lines = []

    prod_win = 0
    old_win = 0
    dates = []
    name = args.name

    with open(args.input, 'r') as file:
        pairs = json.load(file)

    for p in pairs['sbs_metric_results'][0]['sbs_metric_values']['pair_results']:
        if int(p['sys_id_left']) == int(args.prod) and int(p['sys_id_right']) == int(args.old):
            prod_win = p['result']['wins']
            old_win = p['result']['total'] - p['result']['wins']
            break

    print >> sys.stderr, prod_win, old_win
    lines.append('\t'.join([name + '_winrate_fast',str(prod_win/old_win),str(ts)]))
    lines.append('\t'.join([name + '_wins_fast',str(prod_win),str(ts)]))
    lines.append('\t'.join([name + '_loss_fast',str(old_win),str(ts)]))

    if significance(prod_win, old_win, 95):
        lines.append('\t'.join([name + '_winrate_fast_0.95',str(prod_win/old_win),str(ts)]))
        lines.append('\t'.join([name + '_wins_fast_0.95',str(prod_win),str(ts)]))
        lines.append('\t'.join([name + '_wins_loss_0.95',str(old_win),str(ts)]))
    if significance(prod_win, old_win, 99):
        lines.append('\t'.join([name + '_winrate_fast_0.99',str(prod_win/old_win),str(ts)]))
        lines.append('\t'.join([name + '_wins_fast_0.99',str(prod_win),str(ts)]))
        lines.append('\t'.join([name + '_loss_fast_0.99',str(old_win),str(ts)]))

    if not yt.exists(args.path):
        yt.create_table(path = args.path, recursive = True)
    yt.write_table(yt.TablePath(args.path, append = True), [{'timestamp' : ts, 'prod_win' : prod_win, 'old_win' : old_win, 'time' : datetime.datetime.fromtimestamp(ts).strftime('%Y-%m-%d %H:%M')}])


    dates.append(ts)
    for r in yt.read_table(args.path):
        if datetime.datetime.fromtimestamp(r['timestamp']).date() == date and r['timestamp'] != ts:
            dates.append(r['timestamp'])
            prod_win += r['prod_win']
            old_win += r['old_win']
    if len(dates) == 4:
        lines.append('\t'.join([name + '_winrate',str(prod_win/old_win),str(ts)]))
        lines.append('\t'.join([name + '_wins',str(prod_win),str(ts)]))
        lines.append('\t'.join([name + '_loss',str(old_win),str(ts)]))
        if significance(prod_win, old_win, 95):
            lines.append('\t'.join([name + '_winrate_0.95',str(prod_win/old_win),str(ts)]))
            lines.append('\t'.join([name + '_wins_0.95',str(prod_win),str(ts)]))
            lines.append('\t'.join([name + '_loss_0.95',str(old_win),str(ts)]))
        if significance(prod_win, old_win, 99):
            lines.append('\t'.join([name + '_winrate_0.99',str(prod_win/old_win),str(ts)]))
            lines.append('\t'.join([name + '_wins_0.99',str(prod_win),str(ts)]))
            lines.append('\t'.join([name + '_loss_0.99',str(old_win),str(ts)]))
    else:
        print >> sys.stderr, 'Not enough measurements:', len(dates)

    with open(args.output, "w") as out:
        for l in lines:
            out.write(l + '\n')

if __name__ == '__main__':
    main()
