#!/usr/bin/env python
# -*- coding: utf-8 -*-

import argparse
import json
import sys
import urllib2
import base64
import datetime

def HandleOptions():
    parser = argparse.ArgumentParser()
    parser.add_argument("-f", "--file", dest="file", help="File with queries")
    return parser

def main():
    args = HandleOptions().parse_args()

    maxtries = 5

    params = { 'control' : '&exp_confs=testing&test-id=44012',
               'right+logo+3str' : '&exp_confs=testing&test-id=44013',
               'list+logo+3str' : '&exp_confs=testing&test-id=44014',
               'right+logo sometimes+3str' : '&exp_confs=testing&test-id=44015',
               'gallery+logo+3str' : '&exp_confs=testing&test-id=44016',
             }
    print 'timestamp\tquery\t', '\t'.join(params.keys())
    print >> sys.stderr, 'timestamp\tquery\t', '\t'.join(params.keys())

    with open(args.file, "r") as f:
        for line in f:
            tmp = line.split('\t')
            query = tmp[0].strip().decode('utf-8')
            answers = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S') + '\t' + query.encode('utf-8')

            for p in params:
                answers += '\t'
                url = "https://priemka.hamster.yandex.ru/touchsearch?text=" + urllib2.quote(query.encode('utf-8')) + "&noredirect=1&nocache=da&lr=213&json_dump=searchdata.docs" + params[p]
                ok = False
                i = 0
                while i < maxtries:
                    try:
                        response = urllib2.urlopen(url).read()
                    except urllib2.HTTPError, e:
                        print >> sys.stderr, 'HTTP Error', e.code
                        i += 1
                        continue
                    except urllib2.URLError, e:
                        print >> sys.stderr, 'URL Error', e.reason
                        i += 1
                        continue

                    try:
                        result = json.loads(response)
                        ok = True
                        i = maxtries
                    except:
                        print >> sys.stderr, "Invalid response", response
                        i += 1

                if ok:
                    wizard = False
                    for r in result['searchdata.docs']:
                        if "_markers" in r.keys():
                            for m in r["_markers"]:
                                if "NEWS_WIZARD" in m:
                                    wizard = True
                    answers += str(wizard)

            print >> sys.stderr, answers
            print answers


if __name__ == "__main__":
    main()
