#!/usr/bin/env python
# -*- coding: utf-8 -*-

try:
    import job_context as nv
except:
    import nirvana.job_context as nv

import json
import sys
import requests

def main():
    job_context = nv.context()
    outputs = job_context.get_outputs()
    inputs = job_context.get_inputs()
    params = job_context.get_parameters()

    oauth = params.get("sbs-token")

    with open(inputs.get("ticket_id"), "r") as inp:
        tmp = json.load(inp)
        if tmp["state"] == "failed":
            return
        ticket = tmp["sbs-ticket"].split("-")[1]

    #read results
    try:
        print >> sys.stderr, "Reading results #", ticket
        r = requests.get("https://sbs.yandex-team.ru/api/experiment/{ticket}/results".format(ticket=ticket),
                                  headers = { "Content-Type": "application/json",
                                              "Authorization" : "OAuth " + oauth},
                                  verify = False
                         )
    except requests.exceptions.HTTPError as e:
        raise Exception("HTTP Error " + e.code)

    results = r.json()
    target = int(params.get("target-system"))
    val = results["pairs"]["queriesWinRate"][target]["left"]["wins"]
    with open(outputs.get("metrics"), "w") as output:
        output.write(params.get("name") + "_winrate" + "\t" + str(val) +  "\t" + params.get("timestamp")[:10])
    output.close()
    with open(outputs.get("queries"), "w") as output:
        sbs_data = {"st-ticket": tmp["st-ticket"], "workflow-id": tmp["workflow-id"]}
        json.dump(sbs_data, output)
    output.close()


if __name__ == "__main__":
    main()
