#!/usr/bin/env python
# -*- coding: utf-8 -*-

import yt.wrapper as yt
import sys
import argparse
import json
import datetime
import random


def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("--server", dest = "server", help = "mapreduce server", default = "hahn.yt.yandex.net:80", required = False)
    parser.add_argument("--date", dest = "date", help = "date", required = True)
    parser.add_argument("--result", dest = "result", help = "File with quasi-markup", required = True)
    return parser



def main():
    args = HandleOption().parse_args()
    yt.update_config({"proxy": {"url": args.server}})


    table = "//home/freshness/pool/news_wizard/daily/" + args.date + "/assessors_ru"
    queries = set()
    markup = []
    for row in yt.read_table(table):
        if int(row["estimation"]) > 10 and row["news"]:
            queries.add((row["query"], row["user_region"]))
        obj = {
               "ji" : {"date" : row["date"], "query" : row["query"], "region_id" : row["user_region"]},
               "result" : {"news" : row["news"], "estimation" : row["estimation"], "label" : "assessors"}
               }
        markup.append(obj)
    i = 0
    for q in queries:
        print "\t".join([q[0], str(q[1]), "asessors_" + str(i)])
        i += 1

    with open(args.result, "w") as result:
        json.dump(markup, result, indent = 4)

if __name__ == "__main__":
    main()
