#!/usr/bin/env python
# -*- coding: utf-8 -*-

import yt.wrapper as yt
import sys
import argparse
import json
import datetime
import random


def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("--server", dest = "server", help = "mapreduce server", default = "hahn.yt.yandex.net:80", required = False)
    parser.add_argument("--date", dest = "date", help = "date", required = True)
    parser.add_argument("--file", dest = "file", help = "file with metrics", required = True)
    parser.add_argument("--dr", dest = "dr", help = "file with defect rate", required = True)
    parser.add_argument("--bucket", dest = "bucket", help = "file with bucket data", required = True)
    parser.add_argument("--dev", dest = "device", help = "device", required = True)
    parser.add_argument("--ts", dest = "timestamp", help = "timestamp", required = True)
    return parser



def main():
    args = HandleOption().parse_args()
    yt.update_config({"proxy": {"url": args.server}})


    table = "//home/freshness/pool/news_wizard/daily/" + args.date + "/metrics_result_" + args.device
    timestamp = int(args.timestamp[:10])
    if yt.exists(table):
        yt.remove(table)
    queries = {}
    with open(args.file, "r") as file:
        data = json.load(file)
    with open(args.dr, "r") as file:
        defects = json.load(file)
    with open(args.bucket, "r") as file:
        bucket = json.load(file)

    labels = {}
    for q in bucket:
        labels[q["text"]] = q.get("labels")
        if q["timestamp"] > timestamp:
            timestamp = q["timestamp"]
    for q in data:
        q.update({"timestamp" : timestamp, "defect" : defects.get(q["text"]), "labels" : labels.get(q["text"])})
    yt.write_table(yt.TablePath(table), data)

if __name__ == "__main__":
    main()
