#!/usr/bin/env python
# -*- coding: utf-8 -*-

import yt.wrapper as yt
import sys
import argparse
import json
import datetime
import random


def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("--server", dest = "server", help = "mapreduce server", default = "hahn.yt.yandex.net:80", required = False)
    parser.add_argument("--date", dest = "date", help = "date", required = True)
    parser.add_argument("--file", dest = "file", help = "file with queries", required = True)
    return parser



def main():
    args = HandleOption().parse_args()
    yt.update_config({"proxy": {"url": args.server}})


    table = "//home/freshness/pool/news_wizard/daily/" + args.date + "/integral_bucket"
    queries = {}
    with open(args.file, "r") as file:
        for line in file:
            tmp = line.split("\t")
            query = tmp[0].decode("utf-8").lower()
            region = int(tmp[1])
            source = tmp[2].split("_")[0]
            if query in queries:
                queries[query]["src"] += "," + source
                if queries[query]["region"] == 213:
                    queries[query]["region"] = region
            else:
                queries[query] = {"src" : source, "region" : region}
    out = []
    for q in queries.keys():
        out.append({"query" : q, "src" : queries[q]["src"], "region" : queries[q]["region"]})
    yt.write_table(yt.TablePath(table), out)

if __name__ == "__main__":
    main()
