#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import division
import sys
import argparse
import json
import datetime
import time
import random
from collections import defaultdict

def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("--honeypot", dest="honeypot", default = False)
    parser.add_argument("--in_screen", dest="in_screen", required = True)
    parser.add_argument("--in_mark", dest="in_mark", required = True)
    parser.add_argument("--out", dest="out", required = True)
    return parser

HONEYPOT_NUMBER = 50
TASKS_NUMBER = 200

def main():
    args = HandleOption().parse_args()

    screenshot_data = {}
    with open(args.in_screen, "r") as screen:
        data = json.load(screen)
        for scr in data:
            screenshot_data[scr["url"]] = scr["screenshot_url"]


    final_pool = []
    if args.honeypot:
        answers = {}
        with open(args.in_mark, "r") as mark:
            for line in mark:
                tmp = line.strip().split("\t")
                answers[tmp[0]]  = tmp[1]
        for url in screenshot_data:
            final_pool.append({
                                "inputValues": {
                                    "url": url,
                                    "image": screenshot_data[url]
                                },
                                "knownSolutions": {
                                    "result": "News" if answers[url] == "ok" else "Not news"
                                }
            })
    else:
        for url in screenshot_data:
            final_pool.append({
                                "inputValues": {
                                    "url": url,
                                    "image": screenshot_data[url]
                                }
            })

    with open(args.out, "w") as out:
        json.dump(final_pool, out, indent = 4)

if __name__ == '__main__':
    main()
