#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import division
import sys
import argparse
import yt.wrapper as yt
import datetime
import time
from urlparse import urlparse
import json
import requests
from collections import defaultdict
import random

def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("--server", dest = "server", help = "mapreduce server", default = "hahn.yt.yandex.net:80", required = False)
    parser.add_argument("--ts", dest = "timestamp", help = "timestamp", required = True)
    parser.add_argument("--out", dest = "out", help = "output file", required = True)
    parser.add_argument("--input", dest = "input", help = "preprocessed table", required = True)
    return parser


THRESHOLD = 3
BLACKLIST = set(['soccer.ru/news', 'list.rusada.ru', 'm.ligastavok.ru/bets', 'pin-up34.com/ru/promo', 'liveresult.ru/hockey', 'soccerstand.com/ru', 'sports.ru/hockey', 'vringe.com/news', 'android1xbet.com', 'matchtv.ru/news', 'bobsoccer.ru/tags/?tag=35', 'm.sport-express.ru', 'winline.ru/now', 'winline.ru', 'vprognoze.ru', 'footballhd.ru/allnews', '1xbetn.ru', 'soccerlife.ru', 'sport-weekend.com/football', 'pin-up24.com/ru', 'soccer365.ru/predictions', '1xbet.co.zm/ru', 'parimatch.ru', 'sportsdaily.ru', 'eurosport.ru', 'fanat1k.ru/login.php', 'm.betcity.ru', '1xstavka.ru/line', '1x-bet-sports.ru', 'f1news.ru', 'news.sportbox.ru/video', 'bombardir.ru/games', 'sport-express.ru', 'fonbetk.ru', 'm.1xstavka.ru', 'championat.com/football', 'winsedbet.ru', 'olimp.bet', 'superbet.ru/zenit-mirror', 'footballhd.ru', 'sport-weekend.com', 'leon.ru/aktsii', 'skisport.ru', 'bet-rate.com/mirror-1xbet', 'm.myscore.ru', 'eurosport.ru/football', 'gooool.org/&h', 'baltbet.ru/bet.aspx', 'euro-football.ru', 'myscore.ru', 'matchtv.ru/tvguide', 'applapp.ru/ios/melbet', 'iodroid.net', 'melbet365.com/line', 'm.betcity.ru/ru/line', 'gg8.bet/ru/betting-sports', 'mostbet.ru/contacts', '1xbet.co.zm/ru/slots', 'm.championat.com', 'slamdunk.ru/forum', 'championat.asia', 'pin-up34.com/ru', 'soccer365.ru/online', 'fonbet.ru/#', 'skisport.ru/forum', 'kidshockey.ru', 'autospot.ru/brands', 'myscore.ru/basketball', 'sovsport.ru/football', 'soccer365.ru/online/&tab=1', 'illodemiur.ru', 'matchtv.ru/football/live', 'championat.com/auto', '2xxzerkalo.ru', 'betcity.ru', 'iodroid.net/melbet', 'bobsoccer.ru/max', 'leon.ru/cybersport', 'fonbet.ru', 'championat.asia/ru', 'fratria.ru/news', 'fratria.ru', 'mostbet.ru/ios', 'pin-up24.com', 'leon.ru', 'onedivision.ru', 'vprognoze.ru/forecast/pro', 'm.betwinner.com/ru', 'soccerstand.com', 'sportsreg.ru/1xbet-zerkalo', 'melbet365.com', 'applapp.ru/ios/1xbet', 'superbet.ru', '1xbet-life.site', 'sportivnoepitanie.ru', 'hockey.sport-liga.pro', 'news.sportbox.ru', 'sportsreg.ru', 'myscore.ru/tennis', 'vseprosport.ru/news', 'soccer365.ru', 'bombardir.ru', '1win-auto.ru', 'sports.ru/news', 'melbetzerkalo.com', '2xzerkalo.ru', 'autospot.ru', 'chelseablues.ru/video', 'sports.ru/football', 'soccer.ru', 'ligastavok.ru', 'slamdunk.ru', 'm.ligastavok.ru', 'allboxing.ru', 'betfaq.ru/win/premium', 'leon.ru/registration', 'olimp.bet/promotions', '1xbet.co.zm', 'zenit.win', 'vseprosport.ru', 'zenit.win/account', 'bombardir.ru/russia', 'championat.uz/uz', 'matchtv.ru', 'onedivision.ru/ligue-1', 'championat.com/hockey', 'sport-express.ru/news', '1xstavka.ru', 'vprognoze.ru/stavki', 'formulaford.ru', 'vringe.com', 'football.kulichki.net', 'gooool.org', 'fonbet.ru/mobile', '1xbet-help.ru', '1cupis.ru', 'matchpremier.ru', 'bookmaker-ratings.ru', 'sport.ru', 'vk.com', 'olimp.bet/help/news', 'soccer.ru/england', 'bet-rate.com', 'betfaq.ru', 'm.1xstavka.ru/mobile', 'championat.asia/uz', 'championat.uz', 'vk.com/zerkalo_bk_leon', 'bombardir.ru/news', 'sports.ru', 'fratria.ru/fratria', 'fonbeto.ru', 'liveresult.ru', 'm.betwinner.com', 'baltbet.ru/tota.aspx', 'rusfootball.info', 'zenit.win/live', 'bobsoccer.ru', 'm.winline.ru', 'marathonbet.ru', 'news.sportbox.ru/olympics', 'melbet-official.org', 'championat.com', 'gg8.bet', 'gooool.org/films', 'mostbet.ru', 'applapp.ru', 'xxzerkalo.ru', 'vprognoze.ru/forecast', 'matchtv.ru/on-air', 'baltbet.ru', 'fso.forum.cool', 'sports.ru/tennis', 'betwinner-bukmeker.ru', 'vprognoze.ru/topforecast', 'soccer365.ru/news', 'chelseablues.ru', 'eurosport.ru/tennis', '1cupis.ru/info/contacts', 'sovsport.ru', 'zerkalo.fun', 'fonbetk.ru/fonbet-zerkalo', 'agidel-rb.ru', 't.myscore.ru', 'eurosport.ru/snooker', 'f1news.ru/news', 'pin-up34.com', 'onexbit.xyz', 'fanat1k.ru/video.php', 'sport.business-gazeta.ru', '24score.pro'])

def clean(url):
    url = url.lower()
    url = url.replace('https://','')
    url = url.replace('http://','')
    url = url.replace('www.','')
    if url == '':
        return ''
    if url[len(url)-1] == '/':
        url = url[:-1]
    return url

def wordfilter(query):
    markers = [u"зеркало", u"официальный сайт", u"букмекерская контора", u"http", u"фонбет", u"1xbet", u"1хбет", u"париматч", u"фанатик"]
    for m in markers:
        if m in query:
            return m
    return False


class filter(object):
    def __init__(self, list):
        self._list = list

    def __call__(self, rec):
        session = json.loads(rec["value"])
        top_urls = []
        shown = False
        if "results" not in session:
            return
        if session.get("service_dom_region") != "ru":
            return
        if "ui" not in session:
            return
        if random.randint(0,100) != 42:
            return
        elif session["ui"] == 0:
            device = "desktop"
        else:
            device = "touch"
        count = 0
        query = session["query"][:1024]
        for result in session["results"]:
            for element in result["elements"]:
                if len(top_urls) < 3:
                    top_urls.append(clean(element["url"]))
                parsed = urlparse(element["url"])
                host = parsed.netloc
                if host.startswith("www."):
                    host = host[4:]
                if host in self._list:
                    count += 1
        bad_urls = []
        for url in top_urls:
            if url in BLACKLIST:
                bad_urls.append(url)
        is_nav = rec["sprops_REPORT"].get("REPORT.is_nav_request")
        blender_session = json.loads(rec["blender_data"])
        if "blender_results" in blender_session:
            for br in blender_session["blender_results"]:
                for bre in br["blender_elements"]:
                    if bre.get("name") == "sport" or "special/event/sport" in str(bre.get("path")):
                        print >> sys.stderr, bre.get("name"), bre.get("path")
                        shown = True
        yield {"query" : query, "count" : count, "device" : device, "is_nav" : 0 if not is_nav else 1, "bad_urls" : bad_urls, "filter" : wordfilter(query), "show" : True if shown or rec.get("shows_count") else False}

def match_hosts(rec):
    hostclass = "unmarked"
    host = rec["host"]
    sug = json.loads(rec["suggestions"].replace("\'", "\""))
    hostclass = "unknown"
    max = 0
    for c in sug.keys():
        if c == "unknown":
            continue
        if sug[c] > max:
            hostclass = c
            max = sug[c]
    if hostclass == "sport":
        yield {"host": host, "class" : hostclass}

def main():
    args = HandleOption().parse_args()
    yt.update_config({"proxy": {"url": args.server}})

    hostmatches = "//home/search-research/hosts-markup"
    hoststat = set(["allboxing.ru", "allhockey.ru", "allsportinfo.ru", "biathlonrus.com", "championat.com", "euro-football.ru", "football.kulichki.net", "khl.ru",
                    "livesport.ru", "matchtv.ru", "news.sportbox.ru", "rsport.ria.ru", "rusfootball.info", "soccernews.ru", "soccer.ru", "sovsport.ru", "sport.business-gazeta.ru",
                    "sport-express.ru", "sportfm.ru", "sport.ru", "sportsdaily.ru", "sports.ru", "stadium.ru", "vseprosport.ru"
                    ])
    with yt.TempTable(prefix = "quickhosts") as table:
        yt.run_map(match_hosts,
                   source_table = [hostmatches],
                   destination_table = table,
            )
        for row in yt.read_table(table):
            hoststat.add(row["host"])
    timestamp = int(args.timestamp[:10])
    startdate = datetime.datetime.fromtimestamp(timestamp)
    date = startdate.strftime("%Y-%m-%d")
    with yt.TempTable(prefix = "sportshare_") as table:
        yt.run_map(filter(hoststat),
                   source_table = args.input,
                   destination_table = table,
                   spec = {'combine_chunks': True}
                  )
        querystat = {"desktop" : {"sport" : 0, "nosport" : 0, "sport_nonav" : 0, "shows" : 0}, "touch" : {"sport" : 0, "nosport" : 0, "sport_nonav" : 0, "shows" : 0}}
        for row in yt.read_table(table):
            if row["count"] >= THRESHOLD:
                querystat[row["device"]]["sport"] += 1
                if not ((row["is_nav"] and row["bad_urls"]) or row["filter"]):
                    querystat[row["device"]]["sport_nonav"] += 1
                    if row["show"]:
                        querystat[row["device"]]["shows"] += 1
                    else:
                        print >> sys.stderr, row["query"]
            else:
                querystat[row["device"]]["nosport"] += 1
        out = [{"fielddate" : date}]
        for dev in querystat:
            out[0]["sportshare_" + dev] = querystat[dev]["sport"] / querystat[dev]["nosport"]
            out[0]["sportshare_nonav_" + dev] = querystat[dev]["sport_nonav"] / querystat[dev]["nosport"]
            out[0]["sportcoverage_" + dev] = querystat[dev]["shows"] / querystat[dev]["sport_nonav"]

    with open(args.out, "w") as outfile:
        json.dump(out, outfile, indent = 4)


if __name__ == "__main__":
    main()
