#!/usr/bin/env python
# -*- coding: utf-8 -*-

import yt.wrapper as yt
import sys
import libra
import argparse

series=[u'аффтаржжот', u'белыеволки', u'босикомпомостовой', u'братьяпокрови', u'вечернийургант', u'времяпокажет', u'голос', u'голубойогонёк', u'гостиповоскресеньям', u'давайпоженимся', u'детипонедельника', u'доброеутро', u'достучатьсядонебес', u'еврейскоесчастье', u'ералаш', u'ждименя', u'житьздорово', u'здоровожить', u'играйгармонь', u'идеальныйремонт', u'какукрастьмиллион', u'квн', u'контрольнаязакупка', u'ктохочетстатьмиллионером', u'любимаяучительница', u'маргаританазарова', u'модныйприговор', u'мужскоеженское', u'мужскоеженское', u'мужскоеиженское', u'наединесовсеми', u'непутевыезаметки', u'новыйстарыйдом', u'нюхач', u'обезьяньипроделки', u'обнимаянебо', u'ольга', u'оптинапустынь', u'подмосковныевечера', u'познер', u'покавседома', u'полечудес', u'поцелуйменянапрощание', u'практика', u'время', u'пустьговорят', u'расплата', u'сегоднявечером', u'серафимапрекрасная', u'следсокола', u'словопастыря', u'смак', u'смешарики', u'таблетка', u'теориязаговора', u'точьвточь', u'угадаймелодию', u'умницыиумники', u'фазенда', u'человекизакон', u'чтогдекогда', u'шерлокхолмс']
videomarkers = [u'смотреть',u'online',u'онлайн',u'видео',u'выпуск',u'сезон',u'1',u'2',u'3',u'4',u'5',u'6',u'7',u'8',u'9',u'0',u'серия',u'сегодня',u'канал',u'трансляция',u'прямой',u'эфир',u'последний',u'последняя',u'финал',u'первый',u'первая',u'программа',u'передача',u'прямая']
junk = u' \\\'-_.,—"‘’“”•;:›><()#%@!^&*+=№?[]►▼✔/|`~'

def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("--server", dest="server", help="mapreduce server",default='hahn.yt.yandex.net:80', required=False)
    parser.add_argument("--bs", dest="blockstat", help="path to blockstat.dict",default='/home/itajn/serploader/blockstat.dict', required=False)
    return parser

def extract(key, recs):
    uid = key
    try:
        session = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    for request in session:
        if not (request.IsA("TYandexWebRequest") or request.IsA("TMobileYandexWebRequest") or request.IsA("TTouchYandexWebRequest")):
            continue

        region = request.ServiceDomRegion
        if (region == 'ru') or (region == None):
            region = 'ru'
        else:
            continue

        query = request.Query.decode('utf-8').lower().strip()
        for v in videomarkers:
            query = query.replace(v,'')
        for j in junk:
            query = query.replace(j,'')
        for s in series:
            if s == query:
                yield {'query': query}
                continue

def glue(key, recs):
    total = 0
    for r in recs:
        total += 1
    yield { 'query' : key['query'],
            'total' : total
          }


def main():
    args = HandleOption().parse_args()
    yt.update_config({'proxy': {'url': args.server}})

    dates=[ #jan
          '2016-01-04','2016-01-05','2016-01-06','2016-01-07','2016-01-08','2016-01-09','2016-01-10',
            #apr
          '2016-04-20','2016-04-21','2016-04-22','2016-04-23','2016-04-24','2016-04-25','2016-04-26',
            #june
          '2016-06-15','2016-06-16','2016-06-17','2016-06-18','2016-06-19','2016-06-20','2016-06-21',
            #sept
          '2016-09-01','2016-09-02','2016-09-03','2016-09-04','2016-09-05','2016-09-06','2016-09-07'
          ]

    for day in dates:
        usersessions= '//user_sessions/pub/search/daily/' + day + '/clean'
        output = '//home/freshness/staff/itajn/FU-3364/'+day
        if not yt.exists(output):
            yt.create_table(path=output, recursive=True)
        yt.run_reduce(extract,
                      source_table=usersessions,
                      destination_table=output,
                      local_files = [args.blockstat],
                      reduce_by = 'key',
                      spec = {'data_size_per_job': 16000000000}
                      )
        # yt.run_sort(source_table=output,
                    # destination_table=output,
                    # sort_by=['query']
                    # )
        # yt.run_reduce(glue,
                      # source_table=output,
                      # destination_table=output,
                      # reduce_by = ['query']
                      # )
        result = yt.read_table(output)
        total = 0
        for r in result:
            total += 1
        print day, total

if __name__ == '__main__':
    main()
