#!/usr/bin/env python
# -*- coding: utf-8 -*-

import argparse
import datetime
import time
import sys
from copy import copy
import yt.wrapper as yt


def map_crypta(rec):
    yield {"uid": "y" + rec["id"], "crypta_id" : rec["target_id"]}

def glue_crypta(key, recs):
    crypta_id = None
    out = []
    for r in recs:
        if "ts" not in r:
            crypta_id = r["crypta_id"]
        else:
            out.append(copy(r))
    if out: print >> sys.stderr, out
    for res in out:
        res.update({"crypta_id" : crypta_id, "uid" : key["uid"]})
        yield res


def argument_parser():
    parser = argparse.ArgumentParser(description="Get parameters")
    parser.add_argument(
        "-r",
        dest = "rpath",
        type = str,
        help = "result path",
    )
    parser.add_argument(
        "-t",
        dest = "timestamp",
        type = int,
        help = "timestamp",
    )
    args = parser.parse_args()
    return args


def main():
    args = argument_parser()
    timestamp = args.timestamp

    if timestamp > 100000000000:
        timestamp = timestamp / 1000
    startdate = datetime.datetime.fromtimestamp(timestamp)
    current_day = (startdate - datetime.timedelta(1)).strftime("%Y-%m-%d")
    output_path = args.rpath + "/" + current_day
    crypta_path = "//home/crypta/public/matching/by_id/yandexuid/crypta_id"
    crypta_tmp = args.rpath + "/cryptatmp"
    yt.run_map(map_crypta,
               source_table = crypta_path,
               destination_table = crypta_tmp,
               )
    yt.run_sort(source_table = crypta_tmp, destination_table = crypta_tmp, sort_by = "uid")
    with yt.TempTable(prefix = "app_logs") as tmptable:
        yt.run_sort(source_table = output_path, destination_table = tmptable, sort_by = "uid")
        yt.run_reduce(glue_crypta,
                       source_table = [crypta_tmp, tmptable],
                       destination_table = output_path,
                       reduce_by = "uid",
                      )
        yt.run_merge(output_path, output_path, spec={"combine_chunks":True})
    yt.remove(crypta_tmp)

if __name__ == '__main__':
    main()
