#!/usr/bin/env python
# -*- coding: utf-8 -*-

import yt.wrapper as yt
import sys
import argparse
import datetime
import json

def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("--server", dest="server", help="mapreduce server",default='hahn.yt.yandex.net:80', required=False)
    parser.add_argument("--bs", dest="blockstat", help="path to blockstat.dict",default='/home/itajn/serploader/blockstat.dict', required=False)
    parser.add_argument("--mode", dest="mode", help="android or iso",default='android', required=False)
    parser.add_argument("--ts", dest="timestamp", help="timestamp", required=True)
    return parser


def filter(rec):
    if 'ParsedParams_Key1' in rec and rec['ParsedParams_Key1'] == "['Typing']":
        event = json.loads(rec['EventValue'])
        events = json.loads(event['Typing'])
        yield {'date' : rec['StartDate'],
               'type' : 'keys',
               'num' : events['keyCount']
               }
        yield {'date' : rec['StartDate'],
               'type' : 'backspace',
               'num' : events['backspaceCount']
               }

def main():
    args = HandleOption().parse_args()
    yt.update_config({'proxy': {'url': args.server}})

    timestamp = args.timestamp[:10]
    this = datetime.datetime.fromtimestamp(int(timestamp)).strftime('%Y-%m-%d')
    mode = args.mode + '/'
    inputtables = '//home/freshness/keyboard_logs/' + mode + this
    with yt.TempTable(prefix = "tmp_freshness") as output:
        yt.run_map(filter,
                   source_table = inputtables,
                   destination_table = output,
                   )
        total_key = 0
        total_back = 0
        keycount = 0
        backspace = 0
        result=yt.read_table(output)
        for row in result:
            if row['type'] == 'keys':
                total_key += 1
                keycount += row['num']
            else:
                total_back += 1
                backspace += row['num']
    print this, total_key, keycount, total_back, backspace

if __name__ == '__main__':
    main()
