#!/usr/bin/env python
# -*- coding: utf-8 -*-

from copy import deepcopy

import argparse
import urllib
import urllib2
import sys

def HandleOption():
    parser = argparse.ArgumentParser(description='Push metric to razladki')
    parser.add_argument('--project', dest='project', help='project name')
    parser.add_argument('--file', dest='file', help='tsv file with metrics') # name \t value \t timestamp
    args = parser.parse_args()
    return parser

def RobustGet(url):
    for i in range(5):
        try:
            return urllib2.urlopen(url).read()
        except Exception as e:
            print >> sys.stderr, e
            continue
    return None

def main():
    args = HandleOption().parse_args()
    with open(args.file, 'r') as file:
        for row in file:
            tmp = row.strip().split('\t')
            if len(tmp) < 3:
                continue
            if 'inf' in tmp[1] or 'Inf' in tmp[1]:
                continue
            razladkiUrl = 'http://launcher.razladki.yandex-team.ru/save_new_data/%s?%s=%s&ts=%s' % (args.project, tmp[0], tmp[1], tmp[2])
            print >> sys.stderr, RobustGet(razladkiUrl)

if __name__ == '__main__':
    main()

