#!/usr/bin/env python
# -*- coding: utf-8 -*-

import yt.wrapper as yt
import sys
import argparse
import datetime
import json

def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("--server", dest="server", help="mapreduce server",default='hahn.yt.yandex.net:80', required=False)
    return parser

def main():
    args = HandleOption().parse_args()
    yt.update_config({'proxy': {'url': args.server}})

    slices = [1, 7, 14]
    actions = {}
    applications = {}
    popular = ['com.vkontakte.android', 'com.android.vending', 'com.whatsapp', 'com.android.chrome', 'com.yandex.browser', 'com.viber.voip', 'com.android.mms', 'ru.yandex.androidkeyboard', 'com.perm.kate', 'com.android.settings', 'com.google.android.googlequicksearchbox', 'com.google.android.youtube', 'com.instagram.android', 'com.android.contacts', 'org.telegram.messenger', 'com.android.browser', 'com.UCMobile.intl', 'ru.yandex.searchplugin', 'com.vkcoffee.android', 'com.yandex.launcher','com.perm.kate_new_6','com.android.dialer']
    dates = {}
    action_types = ["['Additional symbols on long tap']", "['Applications uses keyboard']", "['Backspace swipe']", "['Commit text debug']", "['Emoji Suggest Select']", "['Emoji Vertical Select']", "['Exception']", "['GIFs for']", "['Globe key status']", "['Globe used']", "['Keyboard layout swipe']", "['Languages count ']", "['MainKeyboardView null in training']", "['Numpad state']", "['Open settings from keyboard']", "['Open settings from launcher']", "['Open speech view']", "['Painter Paste']", "['Space long tap']", "['Speech session']", "['Themes']", "['Translate Paste']", "['Typing']", "['Web Suggest Click']", 'Background only']
    devinfo = ["Go to full screen", "Go to keyboards", "Go to verticals", "Present emoji", "Present location vertical", "Present pictures vertical", "Present translator vertical"]
    input = '//home/freshness/staff/itajn/KA-149/newusers'
    result = yt.read_table(input)
    for row in result:
        if row['last_action'] == 0:
            first = datetime.datetime.fromtimestamp(row['bg_action'])
            last = first
            action = 'Background only'
        else:
            first = datetime.datetime.fromtimestamp(row['first_action'])
            last = datetime.datetime.fromtimestamp(row['last_action'])
            action = row['last_fg']
        first_date = first.strftime('%Y-%m-%d')
        last_date = last.strftime('%Y-%m-%d')
        if action == "['Developer Info']":
            for i in devinfo:
                if i in str(row['last_action_value']):
                    action = i
                    break
        if action == "['Applications uses keyboard']":
            app = json.loads(row['last_action_value'])["Applications uses keyboard"]
            if last_date in applications:
                if app in applications[last_date]:
                    applications[last_date][app] += 1
                else:
                    applications[last_date][app] = 1
            else:
                applications[last_date] = {app:1}
        if first_date in dates:
            dates[first_date]['total'] += 1
        else:
            dates[first_date] = {'total':1}
        for s in slices:
            if last - first >= datetime.timedelta(s):
                if str(s) in dates[first_date]:
                    dates[first_date][str(s)] += 1
                else:
                    dates[first_date][str(s)] = 1
        if last_date in actions:
            if action in actions[last_date]:
                actions[last_date][action] += 1
            else:
                actions[last_date][action] = 1
        else:
            actions[last_date] = {action:1}

    for d in dates:
        out = d + '\t' + str(dates[d]['total']) + '\t'
        for s in slices:
            if str(s) in dates[d]:
                out += str(dates[d][str(s)]) + '\t'
            else:
                out += '0\t'
        for a in action_types:
            if a in actions[d]:
                out += str(actions[d][a]) + '\t'
            else:
                out += '0\t'
        for i in devinfo:
            if i in actions[d]:
                out += str(actions[d][i]) + '\t'
            else:
                out += '0\t'
        if d in applications:
            for p in popular:
                if p in applications[d]:
                    out += str(applications[d][p]) + '\t'
                else:
                    out += '0\t'
        print out

if __name__ == '__main__':
    main()
