#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import division
import sys
import argparse
import json
import datetime
from collections import defaultdict


def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("--server", dest = "server", help = "mapreduce server", default = "hahn.yt.yandex.net:80", required = False)
    parser.add_argument("--sbs", dest = "sbs", help = "by-query results", required = True)
    parser.add_argument("--queries", dest = "queries", help = "Queries with weights in column $3", required = True)
    parser.add_argument("--outs", dest = "outs", help = "File for metrics", required = True)
    parser.add_argument("--dev", dest = "device", help = "Device: desktop/touch", required = True)
    parser.add_argument("--ts", dest = "timestamp", help = "timestamp", required = True)
    parser.add_argument("--name", dest = "name", help = "Sbs name", required = True)
    return parser


def main():
    args = HandleOption().parse_args()

    timestamp = args.timestamp[:10]

    queries = {}
    with open(args.queries) as f:
        for line in f:
            tmp = line.strip().split("\t")
            query = tmp[0].decode("utf-8").lower()
            if not query in queries:
                queries[query] = {"sbs_win" : 0, "sbs_loss" : 0, "weight" : int(tmp[2])}

    with open(args.sbs) as f:
        sbs = json.load(f)
        for res in sbs["sbs_metric_results"][0]["sbs_metric_values"]["custom_results"]:
            query = res["query"]["text"].lower()
            for c in res["comparisons"]:
                for side in ["left", "right"]:
                    if c[side]["sys_id"] == "0":
                        queries[query]["sbs_win"] += c[side]["wins"]
                    else:
                        queries[query]["sbs_loss"] += c[side]["wins"]

    total = 0
    total_w = 0
    wins = 0
    wins_w = 0
    for q in queries:
        total += queries[q]["sbs_win"] + queries[q]["sbs_loss"]
        total_w += queries[q]["weight"] * queries[q]["sbs_win"] + queries[q]["weight"] * queries[q]["sbs_loss"]
        wins += queries[q]["sbs_win"]
        wins_w += queries[q]["weight"] * queries[q]["sbs_win"]

    out = [{"fielddate" : datetime.datetime.fromtimestamp(int(timestamp)).strftime("%Y-%m-%d"), "device" : args.device,
            "weighted" : wins_w/total_w, "unweighted" : wins/total}]
    with open(args.outs, "w") as outfile:
        json.dump(out, outfile, indent = 4)

if __name__ == "__main__":
    main()
