#!/usr/bin/env python
# -*- coding: utf-8 -*-


import urllib2
import requests
import json
import sys
import time
import copy
import datetime

graph = ("4e6484c6-6834-4563-ba55-1b3ea0b3d042","8509263f-b8d7-445f-8677-09542f0d6fc1")
oauth_token = ""
api_path = "https://nirvana.yandex-team.ru/api/public/v1/"
CLONE_WORKFLOW = api_path + "cloneWorkflowInstance?workflowId=%s&workflowInstanceId=%s&targetWorkflowId=%s"
SET_GLOBAL_PARAMETERS = api_path +  "setGlobalParameters?workflowId=%s&params=%s"
START_WORKFLOW = api_path + "startWorkflow?workflowId=%s&workflowInstanceId=%s"
WORKFLOW_STATUS = api_path + "getExecutionState?workflowId=%s&workflowInstanceId=%s"
headers = {'Content-Type': 'application/json', 'Authorization': 'OAuth {}'.format(oauth_token)}


startdate = datetime.datetime(2019,11,10)
enddate = datetime.datetime(2019,4,1)

minutes_wait = 5
max_wait = 90
max_graphs = 3

waiting_list = []

while startdate >= enddate:
    print >> sys.stderr, waiting_list
    check = copy.copy(waiting_list)
    for launch in check:
        date = launch[0]
        instance = launch[1]

        result = requests.get(WORKFLOW_STATUS % (graph[0], instance),
                              headers=headers, verify=False).json()
        if result["result"]["status"] != "running":
            waiting_list.remove(launch)
            print >> sys.stderr, "Done waiting for %s, status: %s. Queue left: %s" % (date, result["result"]["result"], len(waiting_list))
        else:
            print >> sys.stderr, "Still waiting for %s, as of %s. %s" % (date, datetime.datetime.now().strftime("%Y-%m-%d %H-%M"), result["result"]["message"])
    j = 0
    while len(waiting_list) > max_graphs:
        print >> sys.stderr, "Waiting list is too long: %s. Total extra wait is %s m. Extra waiting %s m starting %s" %(len(waiting_list), j*minutes_wait, minutes_wait, datetime.datetime.now().strftime("%Y-%m-%d %H-%M"))
        time.sleep(minutes_wait*60)
        j += 1
        check = copy.copy(waiting_list)
        for launch in check:
            date = launch[0]
            instance = launch[1]
            result = requests.get(WORKFLOW_STATUS % (graph[0], instance),
                              headers=headers, verify=False).json()
            if result["result"]["status"] != "running":
                waiting_list.remove(launch)
                print >> sys.stderr, "Done waiting for %s, status: %s. Queue left: %s" % (date, result["result"]["result"], len(waiting_list))
            else:
                print >> sys.stderr, "Still waiting for %s, as of %s. %s" % (date, datetime.datetime.now().strftime("%Y-%m-%d %H-%M"), result["result"]["message"])

    if startdate != datetime.datetime(2019,10,19):
        result = requests.get(CLONE_WORKFLOW  % (graph[0], graph[1], graph[0]), headers=headers, verify=False).json()
        print >> sys.stderr, result
        instance = result["result"]
        response = requests.post(
            'https://nirvana.yandex-team.ru/api/public/v1/setGlobalParameters',
            data=json.dumps({
                'jsonrpc': "2.0",
                'id': 'id',
                'method': 'setGlobalParameters',
                'params': {
                    'workflowId' : graph[0],
                    "workflowInstanceId" : instance,
                    'params': [
                        {"parameter" : "date", "value" : startdate.strftime("%Y-%m-%d")},
                     ]
                }
            }),
            verify=False,
            headers=headers,
            ).json()

        print >> sys.stderr, response
        result = requests.get(START_WORKFLOW % (graph[0], instance), headers=headers, verify=False).json()
        print >> sys.stderr, result
        i = 0
        while i*minutes_wait < max_wait:
            print >> sys.stderr, "Waiting for %s, total wait time %s m, sleeping for %s m starting from %s" % (startdate.strftime("%Y-%m-%d"), minutes_wait*i, minutes_wait, datetime.datetime.now().strftime("%Y-%m-%d %H-%M"))
            time.sleep(minutes_wait*60)
            i += 1
            result = requests.get(WORKFLOW_STATUS % (graph[0], instance),
                              headers=headers, verify=False).json()
            if result["result"]["status"] != "running":
                print >> sys.stderr, result
                break
        if result["result"]["status"] == "running":
            waiting_list.append((startdate.strftime("%Y-%m-%d"), instance))
    startdate -= datetime.timedelta(1)
