# coding: utf-8


import json
from collections import OrderedDict


AUTHORS = ["itajn"]
OWNERS = ["group:yandex_search_tech_multisearch_videoprod_analysis", "group:yandex_search_tech_sq_8135_6061", "itajn"]
DATE = "2020-11-05"
RUS = {
    "related" : u"в связанных",
    "fromwiz" : u"из колдунщика",
    "serp" : u"на серпе",
}

def add_new(features, metrics, groups):
    new_features = []
    all_feature_keys = set([feature["key"] for feature in features])
    new_metrics = []
    all_metric_keys = set([metric["key"] for metric in metrics])

    ticket = "MMA-4361"
    nf_features = [
        "videoserp_requests_related",
        "videoserp_notfound_related",
        "videoserp_requests_fromwiz",
        "videoserp_requests_fromwiz",
        "videoserp_notfound_fromwiz",
        "videoserp_requests_serp",
        "videoserp_notfound_serp",
    ]
    for feature in nf_features:
        for tail in ["_v$", "_c$"]:
            new_feature = OrderedDict(FEATURE_TEMPLATE)
            new_feature["key"] = "video." + feature + tail
            new_feature["tickets"] = [ticket]
            new_features.append(new_feature)

    new_metric_keys = []
    for metric in ["related", "fromwiz", "serp"]:
            new_metric = OrderedDict(METRIC_TEMPLATE)
            new_metric["key"] = "video.bad_filmid_share_%s" % metric
            new_metric_keys.append(new_metric["key"])
            new_metric["tickets"] = [ticket]
            new_metric["doc"] = "https://st.yandex-team.ru/%s" % ticket
            new_metric["feature_keys"] = [
                "video.videoserp_requests_%s_v$" % metric,
                "video.videoserp_notfound_%s_v$" % metric,
                ]
            new_metric["name"] = u"Доля ненайденных filmid %s" % RUS[metric]
            new_metric["description"] = u"Доля запросов со счётчиком tech/viewer/not_found %s" % RUS[metric]
            new_metric["name_en"] = "Bad filmid share %s" % metric
            new_metric["description_en"] = "Share of requests with tech/viewer/not_found counter %s" % metric
            new_metric["formula"] = "video.videoserp_notfound_%s_v$ / video.videoserp_requests_%s_v$" % (metric, metric)
            new_metrics.append(new_metric)

    for new_feature in new_features:
        features.append(new_feature)
    for new_metric in new_metrics:
        metrics.append(new_metric)

    new_group = OrderedDict(GROUP_TEMPLATE)
    new_group["key"] = "video.video_serp_tech_errors"
    new_group["doc"] = "https://st.yandex-team.ru/%s" % ticket
    new_group["metric_keys"] = new_metric_keys
    new_group["tickets"] = [ticket]
    new_group["name"] = u"Метрики ошибок на видео-серпе"
    new_group["name_en"] = "Metrics on video-serp errors"
    new_group["description"] = u"Метрики ошибок на видео-серпе"
    new_group["description_en"] = "Metrics on video-serp errors"
    groups.append(new_group)

def manual_change(features, metrics, groups):
    add_new(features, metrics, groups)


FEATURE_TEMPLATE = {
        "key": None,
        "calc_type": "abt",
        "doc": "",
        "owners": OWNERS,
        "authors": AUTHORS,
        "tickets": [],
        "date_created": DATE,
        "date_validated": None,
        "is_testing": True,
        "cpp_type": "request",
        "cpp_class": "DEFAULT",
        "cpp_init": "{}"
    }

METRIC_TEMPLATE = {
        "key": None,
        "calc_type": "abt",
        "doc": "https://st.yandex-team.ru/%s",
        "owners": OWNERS,
        "authors": AUTHORS,
        "tickets": [],
        "date_created": DATE,
        "date_validated": None,
        "tag_keys": [],
        "permission_keys": [],
        "hist_keys": [],
        "is_testing": True,
        "ctype": "expression",
        "ftype": "count",
        "name": "Общее количество прямых запросов",
        "name_en": "Total direct request count",
        "description": "Общее количество прямых (не аяксовых) запросов в Вебе",
        "description_en": "Total direct (not ajax) request count in Web",
        "controls_validated": False,
        "reliable": False,
        "elite": False,
        "single": False,
        "less": False,
        "formula": "web.total_request_count_v$ - web.total_ajax_request_count_v$"
    }

GROUP_TEMPLATE = {
        "key": None,
        "calc_type": "abt",
        "doc": "",
        "owners": OWNERS,
        "authors": AUTHORS,
        "tickets": [],
        "date_created": DATE,
        "date_validated": None,
        "group_keys": [],
        "metric_keys": [],
        "permission_keys": [],
        "name": "Метрики колдунщика игр",
        "name_en": "Metrics of games wizard",
        "description": "Метрики колдунщика игр в поиске",
        "description_en": "Metrics of games wizard",
    }
