# coding: utf-8


import json
from collections import OrderedDict


AUTHORS = ["itajn"]
OWNERS = ["group:yandex_search_tech_multisearch_videoprod_analysis", "group:yandex_search_tech_sq_8135_6061", "itajn"]
DATE = "2020-10-29"
TICKET = "MMA-4723"
RUS = {
    "related" : u"в связанных",
    "wizard" : u"из колдунщика",
    "serp" : u"на серпе",
    "wizvital" : u"из колдунщика vital",
    "wizv4t" : u"из колдунщика v4thumbs",
    "wizxl" : u"из колдунщика xl",
    "wizlist" : u"из колдунщика list",
    "wizserial" : u"из колдунщика serial",
    "wizintent" : u"из колдунщика intent",
    "tabbar" : u"из таббара",
}

def add_new(features, metrics, groups):
    new_features = []
    new_metrics = []

    nf_features = [
        "serp",
        "related",
        "wizard",
        "wizvital",
        "wizv4t",
        "wizxl",
        "wizlist",
        "wizserial",
        "wizintent",
        "tabbar",
    ]
    for feature in nf_features:
        for tail in ["v$", "c$"]:
            for t in ["lvt", "tvt"]:
                new_feature = OrderedDict(FEATURE_TEMPLATE)
                new_feature["key"] = "daily.video_session_%s_%s_%s" % (feature, t, tail)
                new_features.append(new_feature)
            new_feature = OrderedDict(FEATURE_TEMPLATE)
            cor_name = feature if (feature != "wizard" and "wiz" not in feature) else feature.replace("wiz", "wizard")
            new_feature["key"] =  "daily.video_users_by_session_%s_%s" % (cor_name, tail)
            new_features.append(new_feature)

    for tail in ["v$", "c$"]:
        new_feature = OrderedDict(FEATURE_TEMPLATE)
        new_feature["key"] = "video.videowiz_max_documents_%s" % tail
        new_feature["tickets"] = ["MMA-5022"]
        new_features.append(new_feature)

    new_metric_keys = []
    for metric in nf_features:
        cor_name = metric if (metric != "wizard" and "wiz" not in metric) else metric.replace("wiz", "wizard")
        for t in ["lvt", "tvt"]:
            new_metric = OrderedDict(METRIC_TEMPLATE)
            new_metric["key"] = "video.video_session_%s_%s" % (t, metric)
            new_metric_keys.append(new_metric["key"])
            new_metric["feature_keys"] = [
                "daily.video_session_%s_%s_v$" % (metric, t),
                ]
            new_metric["name"] = u"%s Я.Видео %s" % (t.upper(), RUS[metric])
            new_metric["description"] = u"%s Я.Видео %s" % (t.upper(), RUS[metric])
            new_metric["name_en"] = "Video %s %s" % (t.upper(), metric)
            new_metric["description_en"] = "Video %s %s" % (t.upper(), metric)
            new_metric["formula"] = "daily.video_session_%s_%s_v$" % (metric, t)
            new_metrics.append(new_metric)
        new_metric = OrderedDict(METRIC_TEMPLATE)
        new_metric["key"] = "video.video_users_session_%s" % cor_name
        new_metric_keys.append(new_metric["key"])
        new_metric["feature_keys"] = [
                "daily.video_users_by_session_%s_v$" % cor_name,
                ]
        new_metric["name"] = u"Аудитория Я.Видео %s" % RUS[metric]
        new_metric["description"] = u"Аудитория Я.Видео %s" % RUS[metric]
        new_metric["name_en"] = "Video users %s" % metric
        new_metric["description_en"] = "Video users %s" % metric
        new_metric["formula"] = "daily.video_users_by_session_%s_v$" % cor_name
        new_metrics.append(new_metric)

    new_metric = OrderedDict(METRIC_TEMPLATE)
    new_metric["key"] = "video.videowiz_list_max_documents_avg"
    new_metric_keys.append(new_metric["key"])
    new_metric["feature_keys"] = [
                "video.videowiz_max_documents_v$",
                "video.videowiz_max_documents_c$",
            ]
    new_metric["name"] = u"Среднее количество документов в колдунщике Видео список"
    new_metric["description"] = u"Среднее количество документов в колдунщике Видео список"
    new_metric["name_en"] = "Average doc in wizvideo-list"
    new_metric["description_en"] = "Average doc in wizvideo-list"
    new_metric["formula"] = "video.videowiz_max_documents_v$ / video.videowiz_max_documents_c$"
    new_metric["tickets"] = ["MMA-5022"]
    new_metric["doc"] = "https://st.yandex-team.ru/MMA-5022"
    new_metrics.append(new_metric)

    for new_feature in new_features:
        features.append(new_feature)
    for new_metric in new_metrics:
        metrics.append(new_metric)

    for group in groups:
        if group["key"] == "video_session":
            for new_metric_key in new_metric_keys:
                group["metric_keys"].append(new_metric_key)
        #elif group["key"] == "video_session":
        #    group["metric_keys"].append("video.videowiz_list_max_documents_avg")

def manual_change(features, metrics, groups):
    add_new(features, metrics, groups)


FEATURE_TEMPLATE = {
        "key": None,
        "calc_type": "abt",
        "doc": "",
        "owners": OWNERS,
        "authors": AUTHORS,
        "tickets": [TICKET],
        "date_created": DATE,
        "date_validated": None,
        "is_testing": True,
        "cpp_type": "request",
        "cpp_class": "DEFAULT",
        "cpp_init": "{}"
    }

METRIC_TEMPLATE = {
        "key": None,
        "calc_type": "abt",
        "doc": "https://st.yandex-team.ru/%s" % TICKET,
        "owners": OWNERS,
        "authors": AUTHORS,
        "tickets": [TICKET],
        "date_created": DATE,
        "date_validated": None,
        "tag_keys": [],
        "permission_keys": [],
        "hist_keys": [],
        "is_testing": True,
        "ctype": "expression",
        "ftype": "count",
        "name": "Общее количество прямых запросов",
        "name_en": "Total direct request count",
        "description": "Общее количество прямых (не аяксовых) запросов в Вебе",
        "description_en": "Total direct (not ajax) request count in Web",
        "controls_validated": False,
        "reliable": False,
        "elite": False,
        "single": False,
        "less": False,
        "formula": "web.total_request_count_v$ - web.total_ajax_request_count_v$"
    }

GROUP_TEMPLATE = {
        "key": None,
        "calc_type": "abt",
        "doc": "https://st.yandex-team.ru/%s" % TICKET,
        "owners": OWNERS,
        "authors": AUTHORS,
        "tickets": [TICKET],
        "date_created": DATE,
        "date_validated": None,
        "group_keys": [],
        "metric_keys": [],
        "permission_keys": [],
        "name": "Метрики колдунщика игр",
        "name_en": "Metrics of games wizard",
        "description": "Метрики колдунщика игр в поиске",
        "description_en": "Metrics of games wizard",
    }
