# coding: utf-8


import json
from collections import OrderedDict


AUTHORS = ["itajn"]
OWNERS = ["group:yandex_search_tech_multisearch_videoprod_analysis", "group:yandex_search_tech_sq_8135_6061", "itajn"]
DATE = "2021-02-19"
RUS = {
    "loaded" : u"загрузки",
    "auth" : u"авторизации",
    "close" : u"закрытия",
    "error" : u"ошибки",
    "success" : u"покупки",
}
EVENTS = ["loaded", "auth", "close", "error", "success"]
BLOCKS = ["central_card", "right_card", "sideblock", "bo", "catalog"]
TYPES = ["plus", "premium", "super_plus", "kp_amediateka"]

def add_new(features, metrics, groups):
    new_features = []
    all_feature_keys = set([feature["key"] for feature in features])
    new_metrics = []
    all_metric_keys = set([metric["key"] for metric in metrics])

    ticket = "MMA-5238"

    for event in EVENTS:
        if event != "success":
            feature = "newplus." + event
            for tail in ["_v$", "_c$"]:
                new_feature = OrderedDict(FEATURE_TEMPLATE)
                new_feature["key"] = feature + tail
                new_feature["tickets"] = [ticket]
                new_features.append(new_feature)
        else:
            for block in BLOCKS:
                for subtype in TYPES:
                    feature = "newplus." + "success_" + subtype + "_" + block
                    for tail in ["_v$", "_c$"]:
                        new_feature = OrderedDict(FEATURE_TEMPLATE)
                        new_feature["key"] = feature + tail
                        new_feature["tickets"] = [ticket]
                        new_features.append(new_feature)

    new_metric_keys = []
    for event in EVENTS:
        if event != "success":
            metric = event
            new_metric = OrderedDict(METRIC_TEMPLATE)
            new_metric["key"] = "newplus.%s" % (metric if metric != "close" else "widget_close")
            new_metric_keys.append(new_metric["key"])
            new_metric["tickets"] = [ticket]
            new_metric["doc"] = "https://st.yandex-team.ru/%s" % ticket
            new_metric["feature_keys"] = [
                    "newplus.%s_v$" % metric,
                    ]
            new_metric["name"] = u"Попап подписки %s" % RUS[metric]
            new_metric["description"] = u"Количество срабатываний счётчика попап подписки - %s" % RUS[metric]
            new_metric["name_en"] = "Plus widget popup %s" % metric
            new_metric["description_en"] = "Plus widget popup %s" % metric
            new_metric["formula"] = "newplus.%s_v$" % metric
            new_metrics.append(new_metric)
        else:
            for block in BLOCKS:
                for subtype in TYPES:
                    metric = "success_" + subtype + "_" + block
                    new_metric = OrderedDict(METRIC_TEMPLATE)
                    new_metric["key"] = "newplus.%s" % metric
                    new_metric_keys.append(new_metric["key"])
                    new_metric["tickets"] = [ticket]
                    new_metric["doc"] = "https://st.yandex-team.ru/%s" % ticket
                    new_metric["feature_keys"] = [
                            "newplus.%s_v$" % metric,
                            ]
                    new_metric["name"] = u"Попап подписки %s блок %s подписка %s" % (RUS[event], block, subtype)
                    new_metric["description"] = u"Количество покупок подписки - блок %s подписка %s" % (block, subtype)
                    new_metric["name_en"] = "Plus widget popup %s %s %s" % (event, block, subtype)
                    new_metric["description_en"] = "Plus widget popup %s %s %s" % (event, block, subtype)
                    new_metric["formula"] = "newplus.%s_v$" % metric
                    new_metrics.append(new_metric)

    for new_feature in new_features:
        features.append(new_feature)
    for new_metric in new_metrics:
        metrics.append(new_metric)

    new_group = OrderedDict(GROUP_TEMPLATE)
    new_group["key"] = "newplus.subscribers_breakdown"
    new_group["doc"] = "https://st.yandex-team.ru/%s" % ticket
    new_group["metric_keys"] = new_metric_keys
    new_group["tickets"] = [ticket]
    new_group["name"] = u"Воронка метрик подписок"
    new_group["name_en"] = "Subscribers breakdown"
    new_group["description"] = u"Воронка метрик подписок"
    new_group["description_en"] = "Subscribers breakdown"
    groups.append(new_group)

def manual_change(features, metrics, groups):
    add_new(features, metrics, groups)


FEATURE_TEMPLATE = {
        "key": None,
        "calc_type": "abt",
        "doc": "",
        "owners": OWNERS,
        "authors": AUTHORS,
        "tickets": [],
        "date_created": DATE,
        "date_validated": None,
        "is_testing": True,
        "cpp_type": "request",
        "cpp_class": "DEFAULT",
        "cpp_init": "{}"
    }

METRIC_TEMPLATE = {
        "key": None,
        "calc_type": "abt",
        "doc": "https://st.yandex-team.ru/%s",
        "owners": OWNERS,
        "authors": AUTHORS,
        "tickets": [],
        "date_created": DATE,
        "date_validated": None,
        "tag_keys": [],
        "permission_keys": [],
        "hist_keys": [],
        "is_testing": True,
        "ctype": "expression",
        "ftype": "count",
        "name": "Общее количество прямых запросов",
        "name_en": "Total direct request count",
        "description": "Общее количество прямых (не аяксовых) запросов в Вебе",
        "description_en": "Total direct (not ajax) request count in Web",
        "controls_validated": False,
        "reliable": False,
        "elite": False,
        "single": False,
        "less": False,
        "formula": "web.total_request_count_v$ - web.total_ajax_request_count_v$"
    }

GROUP_TEMPLATE = {
        "key": None,
        "calc_type": "abt",
        "doc": "",
        "owners": OWNERS,
        "authors": AUTHORS,
        "tickets": [],
        "date_created": DATE,
        "date_validated": None,
        "group_keys": [],
        "metric_keys": [],
        "permission_keys": [],
        "name": "Метрики колдунщика игр",
        "name_en": "Metrics of games wizard",
        "description": "Метрики колдунщика игр в поиске",
        "description_en": "Metrics of games wizard",
    }
