$moscow_date = ($eventtime) -> {
   RETURN CAST(
        CAST($eventtime + 3600*3 AS DateTime)
    AS Date)
};

$get_runtime_clfs = ($tr) -> {
    $runtime_clfs = $tr.runtime_classifiers;
    $is_hot = $runtime_clfs.query_conversion_detector_predict > 1.4 and $runtime_clfs.pay_detector_predict > 0.2;
    $is_ecom = $runtime_clfs.wizdetection_ecom_classifier_prob > 0.2;
    $is_home = $runtime_clfs.wizdetection_home_ecom_classifier_prob > if($tr.ts >= 1654027520, 0.46, 0.3); -- поменяли классификатор https://a.yandex-team.ru/arc/commit/r9528596#file-/trunk/arcadia/search/wizard/data/fresh/WizDetection/formulas_new.pb.txt:R2754
    $is_diy = $runtime_clfs.wizdetection_diy_ecom_classifier_prob > 0.4;
    $is_cehac = $runtime_clfs.wizdetection_cehac_ecom_classifier_prob > 0.44;
    $is_fashion = $runtime_clfs.wizdetection_fashion_ecom_classifier_prob > 0.4;
    return AsStruct(
        True as `all`,
        $is_ecom as is_ecom,
        $is_ecom and $is_home as is_home,
        $is_ecom and $is_diy as is_diy,
        $is_ecom and $is_cehac as is_cehac,
        $is_ecom and $is_fashion as is_fashion,
        $is_ecom and $is_hot as is_ecom_HOT,
        $is_ecom and $is_hot and $is_home as is_home_HOT,
        $is_ecom and $is_hot and $is_diy as is_diy_HOT,
        $is_ecom and $is_hot and $is_cehac as is_cehac_HOT,
        $is_ecom and $is_hot and $is_fashion as is_fashion_HOT,
        $is_ecom and (not $is_hot) as is_ecom_COLD,
        $is_ecom and (not $is_hot) and $is_home as is_home_COLD,
        $is_ecom and (not $is_hot) and $is_diy as is_diy_COLD,
        $is_ecom and (not $is_hot) and $is_cehac as is_cehac_COLD,
        $is_ecom and (not $is_hot) and $is_fashion as is_fashion_COLD,
    )
};

export $get_runtime_clfs, $moscow_date;
