#!/usr/bin/env python
# -*- coding: utf8 -*-

import json
import logging
import sys

import extsearch.images.kernel.cbir.cbirdaemon.protos.similar_features_pb2 as similar_features_pb2
from google.protobuf import message
from google.protobuf.json_format import MessageToJson
import base64
import codecs

class Params:
    pass

def decodeSimilar(value):
    res = {}
    version, data = value.split('@')
    res['version'] = version
    raw = base64.b64decode(data)
    features = similar_features_pb2.TSimilarFeaturesPB()
    features.ParseFromString(raw)
    res['data'] = json.loads(MessageToJson(features))
    return res

if __name__ == "__main__":

    logging.basicConfig(level=logging.INFO)
    params = Params()
    if len(sys.argv) == 1:
        import nirvana.job_context as nv
        ctx = nv.context()
        params.input = ctx.get_inputs().get('input')
        params.mode = ctx.get_parameters()['mode']
        params.output = ctx.get_outputs().get('output')
    else:
        from argparse import ArgumentParser
        parser = ArgumentParser(description='')
        parser.add_argument('--mode', dest='mode', required=True)
        parser.add_argument('--input', dest='input', required=True)
        parser.add_argument('--output', dest='output', required=True)
        params = parser.parse_args()

    if params.mode == 'json':
        info = json.load(open(params.input))
        for url, elem in info.items():
            if 'daemon_result' not in elem or not elem['daemon_result']:
                continue
            if 'image2query' in elem['daemon_result']:
                elem['daemon_result']['image2query_parced'] = decodeSimilar(elem['daemon_result']['image2query'])['data']['ImageFeatures'][0]['Features']
        with open(params.output, 'w') as fOut:
            json.dump(info, fOut, indent = 1)
    elif params.mode == 'raw_res':
        raw = open(params.input).read()
        parced = decodeSimilar(raw)
        with open(params.output, 'w') as fOut:
            json.dump(parced, fOut, indent = 1)

    sys.exit(0)
