#!/usr/bin/env python
# -*- coding: utf8 -*-

import json
import logging
import sys
import yt.wrapper
import yt.wrapper.client
from argparse import ArgumentParser

import extsearch.images.kernel.cbir.cbirdaemon.protos.similar_features_pb2 as similar_features_pb2
from google.protobuf import message
from google.protobuf.json_format import MessageToJson
import base64
import codecs

def decodeSimilar(value):
    res = {}
    if type(value) is str:
        version, data = value.split('@')
        res['version'] = version
        raw = base64.b64decode(data)
        features = similar_features_pb2.TSimilarFeaturesPB()
        features.ParseFromString(raw)
        res['data'] = json.loads(MessageToJson(features))
    return res

if __name__ == "__main__":

    parser = ArgumentParser(description='')
    parser.add_argument('--proxy', dest='proxy', required=True)
    parser.add_argument('--token', dest='token', required=True)
    parser.add_argument('--factors_tmp_path', dest='factors_tmp_path', required=True)
    parser.add_argument('--test_percent', dest='test_percent', type=int, default=10, required=False)
    
    params = parser.parse_args()
    
    yt_client = yt.wrapper.client.Yt(proxy=params.proxy, token=params.token)
    
    
    def make_mapping(row):
        el = row["cbirdaemon"]["image2query"]
        decoded = decodeSimilar(el)
        decoded_res = ''
        if 'data' in decoded:
            if 'ImageFeatures' in decoded['data']:
                if type(decoded['data']['ImageFeatures']) is list:
                    if len(decoded['data']['ImageFeatures']) > 0:
                        if 'Features' in decoded['data']['ImageFeatures'][0]:
                            decoded_res = decoded['data']['ImageFeatures'][0]['Features']
        yield {
            "q_id": row["q_id"],
            "i2q": decoded_res
        }
        
    yt.wrapper.run_map(make_mapping,
                           params.factors_tmp_path + '/cbirdaemon',
                           params.factors_tmp_path + '/decoded',
                           client=yt_client)
    
    sys.exit(0)
