import argparse
import datetime
import sys
import time

from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    clusters,
    Record,
)
import nile
import logging
logging.basicConfig(format='[%(asctime)s] %(filename)s[LINE:%(lineno)d] %(levelname)-8s %(message)s',
                    level=logging.ERROR)


def argument_parser():
    parser = argparse.ArgumentParser(description='Get parameters')
    parser.add_argument(
        '-p',
        dest='pool',
        type=str,
        help='you hahn pool',
    )
    parser.add_argument(
        '-r',
        dest='rpath',
        type=str,
        help='result path',
    )
    parser.add_argument(
        '-t',
        dest='timestamp',
        type=int,
        help='timestamp',
    )
    parser.add_argument(
        '-mf',
        dest='metric',
        type=str,
        help='metric file',
    )
    args = parser.parse_args()
    return args
days_list = ['2017-11-08',
'2017-11-11',
'2017-11-12',
'2017-11-13',
'2017-11-14',
'2017-11-15',
'2017-11-16',
'2017-11-17',
'2017-11-18',
'2017-11-19',
'2017-11-20',
'2017-11-21',
'2017-11-22',
'2017-11-23',
'2017-11-24',
'2017-11-25',
'2017-11-26',
'2017-11-27',
'2017-11-28',
'2017-11-29',
'2017-11-30',
'2017-12-01',
'2017-12-02',
'2017-12-03',
'2017-12-04',
'2017-12-05',
'2017-12-06',
'2017-12-07',
'2017-12-08',
'2017-12-09',
'2017-12-10',
'2017-12-11',
'2017-12-12',
'2017-12-13',
'2017-12-14',
'2017-12-15',
'2017-12-16',
'2017-12-17',
'2017-12-18',
'2017-12-19',
'2017-12-20',
'2017-12-21',
'2017-12-22',
'2017-12-24']

def main():
    args = argument_parser()
    # timestamp = args.timestamp
    job_root = args.rpath
    try:
        for current_date in days_list:




            cluster = clusters.Hahn(pool=args.pool).env(templates=dict(
                job_root=job_root,
                )
            )
            final_result = list(cluster.read('$job_root/{}'.format(current_date)))
            with open(args.metric, 'a') as metric_file:
                for elem in final_result:
                    metric_file.write('{}\t{}\t{}\n'.format(elem['event_type'], elem['count'],
                        str(time.mktime(datetime.datetime.strptime(str(current_date),
                            "%Y-%m-%d").timetuple()))[:-2]))
    except Exception as e:
        print >> sys.stderr, e
        pass

if __name__ == "__main__":
    main()
