import argparse
import datetime
import sys
import time

from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    clusters,
    Record,
)
import nile
import logging
logging.basicConfig(format='[%(asctime)s] %(filename)s[LINE:%(lineno)d] %(levelname)-8s %(message)s',
                    level=logging.ERROR)


def argument_parser():
    parser = argparse.ArgumentParser(description='Get parameters')
    parser.add_argument(
        '-p',
        dest='pool',
        type=str,
        help='you hahn pool',
    )
    parser.add_argument(
        '-r',
        dest='rpath',
        type=str,
        help='result path',
    )
    parser.add_argument(
        '-t',
        dest='timestamp',
        type=int,
        help='timestamp',
    )
    parser.add_argument(
        '-mf',
        dest='metric',
        type=str,
        help='metric file',
    )
    args = parser.parse_args()
    return args
days_list = ['2017-11-11',
'2017-12-21',
'2017-12-22',
'2017-12-23',
'2017-12-24',
'2017-12-25',
'2017-12-26',
'2017-12-27',
'2017-12-28',
'2017-12-29',
'2017-12-30',
'2017-12-31',
'2018-01-01',
'2018-01-02',
'2018-01-03',
'2018-01-04',
'2018-01-05',
'2018-01-06']

def main():
    args = argument_parser()
    # timestamp = args.timestamp
    job_root = args.rpath
    try:
        for current_date in days_list:




            cluster = clusters.Hahn(pool=args.pool).env(templates=dict(
                job_root=job_root,
                )
            )
            final_result = list(cluster.read('$job_root/{}'.format(current_date)))
            with open(args.metric, 'a') as metric_file:
                for elem in final_result:
                    metric_file.write('{}\t{}\t{}\n'.format(elem['event_type'], elem['count'],
                        str(time.mktime(datetime.datetime.strptime(str(current_date),
                            "%Y-%m-%d").timetuple()))[:-2]))
    except Exception as e:
        print >> sys.stderr, e
        pass

if __name__ == "__main__":
    main()
