# -*-coding: utf8 -*-
#!/usr/bin/env python
import sys
import os
import uatraits
from mapreducelib import MapReduceClient, Record
from parselib import SessionRecord, DatesRange


def Map(rec):
    srec = SessionRecord(rec.value)

    if not hasattr(srec, 'type'):
        return

    if not hasattr(srec, 'url'):
        return
    if not hasattr(srec, 'brand_id'):
        return
    if not hasattr(srec, 'provider'):
        return

    if srec.type == 'TRAFFIC':

        brandId = srec.brand_id
        url = srec.url
        if len(url) >250:
            url = url[:250]
            if brandId == 'yandex':
                yield (str(url), '', '')

            if str(url).startswith('http'):

                if str(url).endswith('.jpg'):
                    yield Record('jpg','' ,str(url))
                if str(url).endswith('.jpe'):
                    yield Record('jpe','' ,str(url))
                if str(url).endswith('.jpeg'):
                   yield Record('jpeg','' ,str(url))


                if str(url).endswith('.jxr'):
                    yield Record('jxr','' ,str(url))
                if str(url).endswith('.hdp'):
                    yield Record('hdp','' ,str(url))
                if str(url).endswith('.wdp'):
                    yield Record('wdp','' ,str(url))


                if str(url).endswith('.bmp'):
                    yield Record('bmp','' ,str(url))
                if str(url).endswith('.dib'):
                    yield Record('dib','' ,str(url))


                if str(url).endswith('.ecw'):
                    yield Record('ecw','' ,str(url))

                if str(url).endswith('.ico'):
                    yield Record('ico','' ,str(url))

                if str(url).endswith('.ilbm'):
                    yield Record('ilbm','' ,str(url))


                if str(url).endswith('.jp2'):
                    yield Record('jp2','' ,str(url))
                if str(url).endswith('.j2k'):
                    yield Record('j2k','' ,str(url))
                if str(url).endswith('.jpf'):
                    yield Record('jpf','' ,str(url))
                if str(url).endswith('.jpx'):
                   yield Record('jpx','' ,str(url))
                if str(url).endswith('.jpm'):
                    yield Record('jpm','' ,str(url))
                if str(url).endswith('.mj2'):
                    yield Record('mj2','' ,str(url))


                if str(url).endswith('.rla'):
                    yield Record('rla','' ,str(url))

                if str(url).endswith('.rpf'):
                    yield Record('rpf','' ,str(url))

                if str(url).endswith('.vil'):
                    yield Record('vil','' ,str(url))
                #
                if str(url).endswith('.sid'):
                    yield Record('sid','' ,str(url))

                if str(url).endswith('.pcx'):
                    yield Record('pcx','' ,str(url))

                if str(url).endswith('.png'):
                    yield Record('png','' ,str(url))

                if str(url).endswith('.psd'):
                    yield Record('psd','' ,str(url))

                if str(url).endswith('.tga'):
                    yield Record('tga','' ,str(url))
                if str(url).endswith('.tpic'):
                    yield Record('tpic','' ,str(url))

                if str(url).endswith('.tif'):
                    yield Record('tif','' ,str(url))
                if str(url).endswith('.tiff'):
                    yield Record('tiff','' ,str(url))

                if str(url).endswith('.webp'):
                    yield Record('webp','' ,str(url))

                if str(url).endswith('.xbm'):
                    yield Record('xbm','' ,str(url))


                if str(url).endswith('.xps'):
                    yield Record('xps','' ,str(url))
                if str(url).endswith('.oxps'):
                    yield Record('oxps','' ,str(url))


                if str(url).endswith('.ppm'):
                    yield Record('ppm','' ,str(url))
                if str(url).endswith('.pgm'):
                    yield Record('pgm','' ,str(url))
                if str(url).endswith('.pbm'):
                    yield Record('pbm','' ,str(url))
                if str(url).endswith('.pnm'):
                    yield Record('pnm','' ,str(url))


def main():
    client = MapReduceClient(server='cedar00.search.yandex.net:8013', verbose=True)

    startDay = '20150804'
    endDay = '20150804'

    for day in DatesRange(startDay, endDay):

        srcTable = os.path.join('user_sessions', day,'spy_log')
        print('Map day: ' + day)
        st = 'kosotis/ANGADMIN/ansearch_461'

        try:
            client.runMap(Map, srcTable=srcTable, dstTable=st, appendMode=True, sortMode=True)
        except:
            print("ERROR:", sys.exc_info()[0])
            print('MAP ENDED!!!')
            print('sort ended')
        # client.runReduce(Reduce, srcTable=ST, dstTables=STReduce, appendMode=True)


if __name__ == '__main__': 
    main()
