uthor__ = 'kosotis'

from collections import defaultdict
from datetime import datetime
import urllib
import random
import sys
import os
from mapreducelib import MapReduce, Record, MapReduceClient
from parselib import DatesRange
import libra
import uatraits

def get_clid(request):
    index = request.find('clid=')
    if index == -1:
        return None
    clid_part = request[index + 5:]
    index = clid_part.find('&')
    if index == -1:
        index = clid_part.find('\t')
        if index == -1:
            index = clid_part.find(' ')
            if index == -1:
                index = clid_part.find(';')
                if index == -1:
                    index = clid_part.find('?')
                    if index == -1:
                        return clid_part
    part = clid_part[:index]
    return part


def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return
    try:
        session = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    for request in session:
        if not request.IsA('TYandexWebRequest'):
            continue
        if request.ServiceDomRegion != 'ru':
            continue

        query = request.Query
        qur = query[:250]
        full_request = request.FullRequest
        clid = get_clid(full_request)
        if clid != None:
            if clid == '2229633':
                 yield Record (qur,'',str(clid))


def main():
    MapReduce.useDefaults(server='sakura.search.yandex.net',
                          username='userstats',
                          mrExec='/Berkanavt/bin/mapreduce-dev',
                          verbose=True)

    dd = ['0909','0910','0911','0912','0913','0914','0915','0916','0917','0918','0919','0920','0921','0922']
    for day in dd:
        src = 'user_sessions/2015' + day
        dt0 = 'kosotis/ANSEARCH-481/alt_search'


        # MapReduce.dropTable(dt0)


        MapReduce.runReduce(Reduce,
                            srcTable=src,
                            dstTables=[dt0],
                            files=['/home/kosotis/lib/blockstat.dict'],
                            appendMode=True,
                            sortMode=True
        )


if __name__ == '__main__':
    main()
