from collections import defaultdict
from datetime import datetime
import sys
import os
import uatraits
import urllib
from mapreducelib import MapReduce, Record, MapReduceClient
from parselib import DatesRange
import libra
def map(rec):
    log = rec.value
    key = rec.key
    for rec in log.split(','):
        yield Record(str(rec), '',str(key))

def reduce(key,recs):
    count = str(sum(1 for rec in recs))
    yield Record(key, '', count)

def main():
    MapReduce.useDefaults(server='sakura.search.yandex.net',
                          username='userstats',
                          mrExec='/Berkanavt/bin/mapreduce-dev',
                          verbose=True)

    src = os.path.join('riddle','reqid_testid_finish_20151205')

    dst_map = 'kosotis/ANSEARCH-524/test_id'
    dst_result = 'kosotis/ANSEARCH-524/test_id_uniq'

    MapReduce.runMap(map,srcTable=src,dstTables=[dst_map],appendMode=True,sortMode=True)
    MapReduce.runReduce(reduce,srcTable=dst_map,dstTables=[dst_result],appendMode=True,sortMode=True)

if __name__ == '__main__':
    main()
