# -*-coding: utf8 -*-
author__ = 'kosotis'

# импортируем необходимые модули
from datetime import datetime
import os
from mapreducelib import MapReduce, Record, MapReduceClient
from parselib import DatesRange

def get_set_day(rec): # функция Map
    log = rec.value # присваиваем переменной "log" записи лежащие в value в redir_log
    get_uid = log.rindex('@@') # с помощью метода "rindex" получаем индекс последнего вхождения "@@" (в redir_log именно за ним находится uid) и присваиваем переменной get_uid
    uid = log[get_uid + 2:]# извлекая срез от 'get_uid' без первых двух элементов(в данном случае "@@") и до конца строки, получаем uid
    tms = log.split('@@')[-3] # сплитим (разбиваем запись в список) по элементу "@@", и берем 3 элемент с конца[-3]. В случаи с redir_log именно там находится timestamp.
    if not tms.isdigit():# проверяем что полученное значение содаржит только цифры
        return # уходим если предыдущее условие не выполняется
    date = datetime.fromtimestamp(int(tms)).strftime('%Y-%m-%d') # используя модуль 'datetime' преобразуем timestamp в привычный формат(2016-02-08) и присваиваем переменной "date"

    if uid == '': # проверяем что uid присутствует и не пустой
        return
    if not uid.isdigit(): # проверяем что uid сожержит только цифры. В отличие от user_sessions, в redir_log uid лежит без первого символа "y"
        return
    if 'productname=winsearchbar' in log: # проверяем что в записи присутсвует нужный нам productname.
        if 'dayuse=0' in log: # проверяем на вхождение соответствующего dayuse. Аналогичным образом можно прикрутить проверку на clid,версию расширения, и т.д
            yield Record(uid + '\t' + str(date), '', str(log)) # в случае выполнения всех условий пишем uid,date в ключ таблицы, и log в значение(для проверить глазами, все ли учли и корректно достали)путь к результирующей таблице укажем ниже.


def reduce(key, recs): # функция Reduce
    count = str(sum(1 for rec in recs)) # на стадии reduce уникализируем записи по ключу (в данном случае uid + date)
    yield Record(key, '', count) # пишем в результирующую табличку



def main():
    # используя метод useDefoult передаем параметры server,username и т.д (почитать тут https://wiki.yandex-team.ru/mapreduce/mapreducelibpy/)
    MapReduce.useDefaults(server='sakura.search.yandex.net',
                          username='userstats',
                          mrExec='/Berkanavt/bin/mapreduce-dev',
                          verbose=True)


    src_Redir = 'kosotis/Test_556/uid_Dayuse0' # путь к результирующей таблице после Map присваиваем переменной src_Redir (формат: 'username'->'dir'->'table_name')
    dst_Redir = 'kosotis/Test_556/uid_Dayuse0_uniq' # путь к результирующей таблице после Reduce присваиваем переменной dst_Redir
    local_result = '/place/home/kosotis/Test_556/uid_Dayuse0_uniq.txt' # путь для записи результирующего файла на машинку porshe.

    # указываем начальную и конечную даты
    startDay = '20160117'
    endDay = '20160131'

    for day in DatesRange(startDay, endDay): # итерируемся по указанному периоду
        src = os.path.join('redir_log', day) # указываем путь к таблице с нужными логами (в данном случае redir_log

    # метод удаления таблиц(в данном случае не отрабатывает, т.е закоментирован)

    # MapReduce.dropTable(src_Redir)
    # MapReduce.dropTable(dst_Redir)


        MapReduce.runMap(get_set_day, srcTable=src, dstTable=src_Redir, appendMode=True, sortMode=True) # запускаем map-транзакцию - в метод 'MapReduce.runMap' подаем функцию get_set_day описаную выше, путь к исходной таблице(записан в переменной srcTable), путь к результирующей табличке(dstTable)
    MapReduce.runReduce(reduce, srcTable=src_Redir, dstTable=dst_Redir, appendMode=True, sortMode=True) # запускаем reduce-транзакцию, в метод 'MapReduce.runReduce' подаем функию reduce, и аналогично предыдущему указываем путь к исходной и результирующей таблицам

    # сохраняем  reduce таблицу себе на машинку. В переменной local_result лежит путь указанный выше
    with open(local_result, 'w') as stream_writer:
        for rec in MapReduce.getSample(srcTable=dst_Redir):
            stream_writer.write(rec.key + '\t' + rec.subkey + '\t' + rec.value + '\n')

if __name__ == '__main__':
    main()

