# -*-coding: utf8 -*-
author__ = 'kosotis'

#импортируем необходимые модули. В данном случае считаем по user_session и используем библиотеку libra, читать тут (https://wiki.yandex-team.ru/JandeksPoisk/KachestvoPoiska/UserData/libra/)
from datetime import datetime
import os
import libra
from mapreducelib import MapReduce, Record, MapReduceClient
from parselib import DatesRange
dayuse_list = list() # создаем пустой список в который запишем uid + date c файлика 'Dayuse0'
for i in open('Dayuse0.txt'): # итерируемся по строкам из файла(файл должен находиться в директории откуда запускаем скрипт)
    set_uid = i.strip().split('\t''\t')[0] #убираем начальные, конечные пробела(strip) и сплитим (разбиваем строку на список по символу двойного таба,
# и забираем первую часть под индексом [0] где находится uid и date, и присваиваем ее переменной set_uid
    dayuse_list.append(set_uid) # записываем результат в ранее созданный список(dayuse_list)

def get_first_query(key, recs):# функция Map
    dayuse_list = list() # создаем пустой список в который запишем uid + date c файлика 'Dayuse0'
    for i in open('Dayuse0.txt'): # итерируемся по строкам из файла
        set_uid = i.strip().split('\t''\t')[0] #убираем начальные, конечные пробела(strip) и сплитим (разбиваем строку на список по символу двойного таба,
    # и забираем первую часть под индексом [0] где находится uid и date, и присваиваем ее переменной set_uid
        dayuse_list.append(set_uid) # записываем результат в ранее созданный список(dayuse_list)
    uid_try = key # в user_sessions uid в частности находится в key. Присваиваем переменной uid_try его значение
    if uid_try[0] != 'y': #дополнительно проверяем что первый символ ключа 'y'. В отличие от redir_log, в user_sessions uid пишется в формате 'y****************'
        return # если предыдущее условие не выполняется, уходим
    uid = uid_try[1:] # т.к в файлике 'Dayuse0.txt', сгенереным первым скриптом, uid лежит без первого символа 'y',
    # а нам требется пересеч uid + date с файла и с логами user_sessions(что-бы отсечь запросы от пользователей в день установки), ТО убираем первый символ 'y' с uid.

    try:
        session = libra.ParseSession(recs, './blockstat.dict')  # передаем переменной session список записей из user_sessions и путь к blockstat.dict. На выходе получаем список объектов типа Request


    # ниже прикручиваем except что-бы игнорировать ошибку RuntimeError, игнорируем fat user (пользователей с большим количеством событий)
    except RuntimeError as e:
        print(e) # если словили, выводи в консоль ошибку
        if 'fat user' in str(e):
            return
        if 'ParseSession can' in str(e):
            return
        else:
            raise e

    for request in session: #итерируемся по запросам и достаем действия пользователя
        if not request.IsA('TYandexWebRequest'): #оставляем только запросы к десктопному поиску (можно отдельно отфильтровать запросы к планшетам или мобильным)
            continue
        # если требуется определенный домен, пишем:
         #if request.ServiceDomRegion != 'ru':
            #continue



        query = request.Query # объект Request имеет поля и методы, достаем нужные нам поля -  текст запроса, fullrequest,referer,date
        fullrequest = request.FullRequest
        referer = request.Referer
        req_ts = request.Timestamp
        date = datetime.fromtimestamp(req_ts).isoformat().split('T')[0]
        all_uid = str(uid) + '\t' + str(date) # полученный uid + date c user_sessions присваиваем переменной all_uid
        if referer: # проверяем или в записи есть реферер
            return # если есть, то это перезапрос, которые нас не интересуют, уходим
        if not 'clid=2246298' in fullrequest: # если в fullrequest нет нужного нам клида (голосовой поиск в данном случае), уходим.
            return
        if all_uid in dayuse_list: # проверяем совпадение uid+date в user_sessions и  uid+date с нашего списка (в который мы сложили пользователей установивших расширение в конкретный день)
        # если совпадает то уходим, т.к интересуют запросы не в день установки
            return
        yield Record(str(query), '', '') #пишем запросы в таблицу


def reduce(key, recs):
    res = str(sum(1 for rec in recs))
    yield Record(key, '', res)


def main():
    MapReduce.useDefaults(server='sakura.search.yandex.net',
                          username='userstats',
                          mrExec='/Berkanavt/bin/mapreduce-dev',
                          verbose=True)

    srcUserS = 'kosotis/Test_556/allQuery'
    dstUserS = 'kosotis/Test_556/allQuery_uniq'
    localresult0 = '/place/home/kosotis/Test_556/local_allQuery_uniq.txt'

    startDay = '20160117'
    endDay = '20160117'


    # MapReduce.dropTable(srcUserS)
    # MapReduce.dropTable(dstUserS)

    for day in DatesRange(startDay, endDay):
        src_u = os.path.join('user_sessions', day)
        MapReduce.runReduce(get_first_query, srcTable=src_u, dstTables=[srcUserS],
                            files=['/home/kosotis/lib/blockstat.dict', '/home/kosotis/Ansearch_556/Dayuse0.txt'],
                            appendMode=True, sortMode=True) # аналогично описанию в первом скрипте, только добавлен параметр 'files=' в котором мы передаем путь к нашему blockstat.dict,
                            # который можно получить так: curl https://stat.yandex-team.ru/export_something_to_search.cgi?type=blockstat_dict > blockstat.dict. И путь к нашему файлу 'Dayuse0'

    MapReduce.runReduce(reduce, srcTable=srcUserS, dstTable=dstUserS, appendMode=True, sortMode=True)

    with open(localresult0, 'w') as stream_writer:
        for rec in MapReduce.getSample(srcTable=dstUserS0):
            stream_writer.write(rec.key + '\t' + rec.subkey + '\t' + rec.value + '\n')


if __name__ == '__main__':
    main()

