#!/usr/bin/env python2
# -*- coding: utf8 -*-
import urllib
import json
import argparse
from optparse import Option
from optparse import OptionParser
from copy import copy


class MyExtendedOption(Option):
    FILECONTENT_TYPE = "filecontent"
    TYPES = Option.TYPES + (FILECONTENT_TYPE,)
    TYPE_CHECKER = copy(Option.TYPE_CHECKER)

    def get_filevalue(option, opt, value):
        with open(value, "r") as stream_reader:
            return stream_reader.read()

    TYPE_CHECKER[FILECONTENT_TYPE] = get_filevalue


def get_options():
    p = OptionParser(option_class=MyExtendedOption)
    p.add_option("--language", type=MyExtendedOption.FILECONTENT_TYPE)
    p.add_option("--doc_count", type=str)

    (options, args) = p.parse_args()
    return options


def main():
    options = get_options()
    options.language = 'Indonesian'
    options.doc_count = 'doc_count.txt'
    url_solomom = 'url_solomon.txt'
    description_language = 'description.txt'

    page = urllib.urlopen('http://api.solomon.search.yandex.net/data-api/get?project=kiwi'
                          '&cluster=main&service=combinator&l.combinator=DocumentsPerLanguageCountFinal'
                          '&who=aaa&b=60m')
    json_data = json.load(page)
    json_data_sensors = json_data['sensors']
    doc_value = None
    url_link = None
    description = None
    for sensor in json_data_sensors:
        labels = sensor['labels']
        language = labels['field']
        values = sensor['values']
        for rec in values:
            date = rec['ts'].split('T')[0]
            time = rec['ts'].split('T')[1][:-1]
            documentsCount = rec['value']

            if options.language == language:
                print(str(date) + ' ' + str(time) + ' ' + str(language) + ' ' + str(documentsCount))
                doc_value = (str(documentsCount))
                url_link = 'https://solomon.yandex-team.ru/?project=kiwi&cluster=main&service=combinator&combinator=DocumentsPerLanguageCountFinal&field=' + language + '&graph=auto'
                print((url_link))
                description = str(language)
                print(description)

    with open(options.doc_count, 'w') as data_to_nirvana_doc:
        data_to_nirvana_doc.write(doc_value)
    with open(url_solomom, 'w') as data_to_nirvana_url:
        data_to_nirvana_url.write(url_link)
    with open(description_language, 'w') as data_to_nirvana_description:
        data_to_nirvana_description.write(description)


if __name__ == '__main__':
    main()






