import argparse
import datetime
import sys

from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    clusters,
    Record,
)
import nile
import logging
import yt.wrapper as yt
logging.basicConfig(format='[%(asctime)s] %(filename)s[LINE:%(lineno)d] %(levelname)-8s %(message)s',
                    level=logging.ERROR)


def argument_parser():
    parser = argparse.ArgumentParser(description='Get parameters')
    parser.add_argument(
        '-p',
        dest='pool',
        type=str,
        help='you hahn pool',
    )
    parser.add_argument(
        '-r',
        dest='rpath',
        type=str,
        help='result path',
    )
    parser.add_argument(
        '-t',
        dest='timestamp',
        type=int,
        help='timestamp',
    )
    parser.add_argument(
        '-mf',
        dest='metric',
        type=str,
        help='metric file',
    )
    parser.add_argument(
        '-dc',
        dest='cl',
        type=str,
        help='cluster_type',
    )



    args = parser.parse_args()
    return args


def main():
    args = argument_parser()
    timestamp = args.timestamp
    job_root = args.rpath

    cl = args.cl
    print >> sys.stdout,cl
    cluster_type = cl.title()

    if timestamp > 100000000000:
        timestamp = timestamp / 1000

    yt.config.set_proxy(str(cl))
    log_table_list = yt.list(job_root)
    needed_table = None
    for table in log_table_list:
        if (int(table) <= timestamp) and (int(table) > timestamp - 1800):
            needed_table = table
    if needed_table is None:
        logging.error('Table not found')
    else:
        cluster = clusters.cluster_type(pool=args.pool).env(templates=dict(
            job_root=job_root,
            )
        )
        final_result = list(cluster.read('$job_root/{}'.format(needed_table)))
        with open(args.metric, 'w') as metric_file:
            for elem in final_result:
                metric_file.write('{}\t{}\t{}\n'.format(elem['event_type'], elem['count'], needed_table))

if __name__ == "__main__":
    main()
