import argparse
import datetime

from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    clusters,
    Record,
)
import nile
import logging
logging.basicConfig(format='[%(asctime)s] %(filename)s[LINE:%(lineno)d] %(levelname)-8s %(message)s',
                    level=logging.ERROR)


def argument_parser():
    parser = argparse.ArgumentParser(description='Get parameters')
    parser.add_argument(
        '-p',
        dest='pool',
        type=str,
        help='you hahn pool',
    )
    parser.add_argument(
        '-r',
        dest='rpath',
        type=str,
        help='result path',
    )
    parser.add_argument(
        '-t',
        dest='timestamp',
        type=int,
        help='timestamp',
    )
    parser.add_argument(
        '-mf',
        dest='metric',
        type=str,
        help='metric file',
    )
    args = parser.parse_args()
    return args


def main():
    args = argument_parser()
    timestamp = args.timestamp
    job_root = args.rpath

    if timestamp > 100000000000:
        timestamp = timestamp / 1000

    current_day = datetime.datetime.fromtimestamp(timestamp) - datetime.timedelta(60)
    current_date = '{}-{:0>2}-{:0>2}'.format(
        current_day.year,
        current_day.month,
        current_day.day
    )

    cluster = clusters.Hahn(pool=args.pool).env(templates=dict(
        job_root=job_root,
        )
    )
    final_result = list(cluster.read('$job_root/{}'.format(current_date)))

    result_dict = {}
    for elem in final_result:
        result_dict['zen|turbo|total_turbo_click'] = elem['turbo_count']
        result_dict['zen|turbo|total_turbo_click_freq'] = elem['turbo_freq']
        result_dict['zen|total_click'] = elem['count']

    with open(args.metric, 'w') as metric_file:
        for elem in result_dict:
            metric_file.write('{}\t{}\t{}\n'.format(
                elem,
                result_dict[elem],
                timestamp-60*60*24
            ))


if __name__ == "__main__":
    main()
